/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.ApiServiceMethodTable;
import tech.ytsaurus.client.ClientPool;
import tech.ytsaurus.client.ErrorHandlingClient;
import tech.ytsaurus.client.misc.ScheduledSerializedExecutorService;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.rpc.TReqDiscover;
import tech.ytsaurus.rpc.TRspDiscover;

@NonNullApi
@NonNullFields
class SelfCheckingClient
extends ErrorHandlingClient {
    private static final Logger logger = LoggerFactory.getLogger(ClientPool.class);
    private static final Duration PING_PERIOD = Duration.ofSeconds(5L);
    private static final Duration PING_TIMEOUT = Duration.ofSeconds(5L);
    final ScheduledExecutorService executorService;
    final RpcOptions options;
    volatile CompletableFuture<RpcClientResponse<TRspDiscover>> pingResult = CompletableFuture.completedFuture(null);

    SelfCheckingClient(RpcClient innerClient, RpcOptions options, CompletableFuture<Void> statusFuture) {
        super(innerClient, statusFuture);
        this.options = new RpcOptions();
        this.options.setDefaultRequestAck(options.getDefaultRequestAck());
        this.options.setGlobalTimeout(PING_TIMEOUT);
        this.executorService = new ScheduledSerializedExecutorService(innerClient.executor());
        this.executorService.submit(this::scheduleNextPing);
    }

    void scheduleNextPing() {
        this.pingResult.whenComplete((result, error) -> {
            if (error != null) {
                logger.debug("Self checking client {} detected ping error: ", (Object)this, error);
                this.statusFuture.completeExceptionally((Throwable)error);
            } else if (result != null && !((TRspDiscover)result.body()).getUp()) {
                logger.debug("Self checking client {} detected proxy is down", (Object)this);
                this.statusFuture.completeExceptionally(new RuntimeException("Proxy is down"));
            } else {
                this.executorService.schedule(() -> {
                    RpcClientRequestBuilder<TReqDiscover.Builder, TRspDiscover> requestBuilder = ApiServiceMethodTable.DISCOVER.createRequestBuilder(this.options);
                    requestBuilder.header().setRequestCodec(Compression.None.getValue());
                    requestBuilder.header().setResponseCodec(Compression.None.getValue());
                    this.pingResult = requestBuilder.invoke(this);
                    this.scheduleNextPing();
                }, PING_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
            }
        });
    }
}

