/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.Parser;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.StreamWriterImpl;
import tech.ytsaurus.client.TableRowsSerializerUtil;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;
import tech.ytsaurus.rpcproxy.TRspWriteShuffleData;

public class ShuffleDataWriterImpl
extends StreamWriterImpl<TRspWriteShuffleData>
implements AsyncWriter<UnversionedRow>,
RpcStreamConsumer {
    private final TableRowsWireSerializer<UnversionedRow> tableRowsSerializer = new TableRowsWireSerializer<UnversionedRow>(new UnversionedRowSerializer());
    private final TableSchema schema;

    public ShuffleDataWriterImpl(long windowSize, long packetSize, String partitionColumnName) {
        super(windowSize, packetSize);
        this.schema = TableSchema.builder().addValue(partitionColumnName, ColumnValueType.INT64).addValue("data", ColumnValueType.STRING).build();
    }

    @Override
    protected Parser<TRspWriteShuffleData> responseParser() {
        return TRspWriteShuffleData.parser();
    }

    public CompletableFuture<AsyncWriter<UnversionedRow>> startUpload() {
        return this.startUpload.thenApply(unused -> this);
    }

    @Override
    public CompletableFuture<Void> write(List<UnversionedRow> rows) {
        try {
            TRowsetDescriptor descriptor = this.tableRowsSerializer.getCurrentRowsetDescriptor(this.schema);
            this.tableRowsSerializer.write(rows, this.schema, descriptor);
            byte[] serializedRows = TableRowsSerializerUtil.serializeRowsWithDescriptor(this.tableRowsSerializer, descriptor);
            if (this.push(serializedRows)) {
                return CompletableFuture.completedFuture(null);
            }
            return this.readyEvent().thenCompose(unused -> this.write(rows));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public CompletableFuture<?> finish() {
        return this.close();
    }
}

