/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import NYT.NChunkClient.NProto.DataStatistics;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;
import tech.ytsaurus.rpcproxy.TRowsetStatistics;

abstract class TableAttachmentRowsetReader<T>
implements TableAttachmentReader<T> {
    protected final AtomicLong totalRowCount = new AtomicLong(-1L);
    @Nullable
    protected volatile DataStatistics.TDataStatistics currentDataStatistics;
    @Nullable
    protected volatile TRowsetDescriptor currentRowsetDescriptor;
    @Nullable
    protected volatile TableSchema currentReadSchema;

    TableAttachmentRowsetReader() {
    }

    protected abstract List<T> parseMergedRow(ByteBuffer var1, int var2);

    protected void parseDescriptorDelta(ByteBuffer bb, int size) throws Exception {
        int endPosition = bb.position() + size;
        TRowsetDescriptor rowsetDescriptor = TRowsetDescriptor.parseFrom((ByteBuffer)bb.slice().limit(size));
        ApiServiceUtil.validateRowsetDescriptor(rowsetDescriptor);
        if (this.currentReadSchema == null) {
            this.currentRowsetDescriptor = rowsetDescriptor;
            this.currentReadSchema = ApiServiceUtil.deserializeRowsetSchema(rowsetDescriptor);
        } else if (rowsetDescriptor.getNameTableEntriesCount() > 0) {
            TRowsetDescriptor.Builder builder = TRowsetDescriptor.newBuilder();
            builder.mergeFrom(this.currentRowsetDescriptor);
            builder.addAllNameTableEntries((Iterable)rowsetDescriptor.getNameTableEntriesList());
            this.currentRowsetDescriptor = builder.build();
            Objects.requireNonNull(this.currentRowsetDescriptor);
            this.currentReadSchema = ApiServiceUtil.deserializeRowsetSchema(this.currentRowsetDescriptor);
        }
        bb.position(endPosition);
    }

    protected List<T> parseRowData(ByteBuffer bb, int size) throws Exception {
        int endPosition = bb.position() + size;
        int parts = bb.getInt();
        if (parts != 2) {
            throw new IllegalArgumentException();
        }
        int descriptorDeltaSize = (int)bb.getLong();
        this.parseDescriptorDelta(bb, descriptorDeltaSize);
        int mergedRowSize = (int)bb.getLong();
        List<T> rowset = this.parseMergedRow(bb, mergedRowSize);
        if (bb.position() != endPosition) {
            throw new IllegalArgumentException();
        }
        return rowset;
    }

    private void parseStatistics(ByteBuffer bb, int size) throws Exception {
        int endPosition = bb.position() + size;
        TRowsetStatistics statistics = TRowsetStatistics.parseFrom((ByteBuffer)bb.slice().limit(size));
        this.currentDataStatistics = statistics.getDataStatistics();
        this.totalRowCount.set(statistics.getTotalRowCount());
        bb.position(endPosition);
    }

    private List<T> parseRowsWithStatistics(@Nullable byte[] attachment, int offset, int length) throws Exception {
        if (attachment == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(attachment, offset, length).order(ByteOrder.LITTLE_ENDIAN);
        int parts = bb.getInt();
        if (parts != 2) {
            throw new IllegalArgumentException();
        }
        int rowDataSize = (int)bb.getLong();
        List<T> rowset = this.parseRowData(bb, rowDataSize);
        int statisticsSize = (int)bb.getLong();
        this.parseStatistics(bb, statisticsSize);
        if (bb.hasRemaining()) {
            throw new IllegalArgumentException();
        }
        return rowset;
    }

    @Override
    public List<T> parse(@Nullable byte[] attachments, int offset, int length) throws Exception {
        return this.parseRowsWithStatistics(attachments, offset, length);
    }

    @Override
    public List<T> parse(@Nullable byte[] attachments) throws Exception {
        if (attachments == null) {
            return null;
        }
        return this.parseRowsWithStatistics(attachments, 0, attachments.length);
    }

    @Override
    public long getTotalRowCount() {
        return this.totalRowCount.get();
    }

    @Override
    public DataStatistics.TDataStatistics getDataStatistics() {
        return this.currentDataStatistics;
    }

    @Override
    @Nullable
    public TableSchema getCurrentReadSchema() {
        return this.currentReadSchema;
    }
}

