/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import tech.ytsaurus.client.TableAttachmentRowsetReader;
import tech.ytsaurus.client.rows.EntitySkiffSerializer;
import tech.ytsaurus.skiff.SkiffParser;

public class TableAttachmentSkiffReader<T>
extends TableAttachmentRowsetReader<T> {
    private final EntitySkiffSerializer<T> serializer;

    TableAttachmentSkiffReader(EntitySkiffSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public EntitySkiffSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    protected List<T> parseMergedRow(ByteBuffer buffer, int size) {
        byte[] data = new byte[size];
        buffer.get(data);
        SkiffParser parser = new SkiffParser((InputStream)new ByteArrayInputStream(data));
        ArrayList<T> deserializedObjects = new ArrayList<T>();
        while (parser.hasMoreData()) {
            parser.parseInt16();
            deserializedObjects.add(this.serializer.deserialize(parser).orElseThrow(() -> new IllegalStateException("Cannot deserialize object")));
        }
        return deserializedObjects;
    }
}

