/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import com.google.protobuf.CodedOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableRowsProtobufSerializer;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.client.TableRowsSkiffSerializer;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.TableRowsYsonSerializer;
import tech.ytsaurus.client.request.SerializationContext;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.core.utils.ClassUtils;
import tech.ytsaurus.rpcproxy.ERowsetFormat;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;

class TableRowsSerializerUtil {
    private static final String YSON = "yson";

    private TableRowsSerializerUtil() {
    }

    static <T> Optional<TableRowsSerializer<T>> createTableRowsSerializer(SerializationContext<T> context, SerializationResolver serializationResolver) {
        if (context.getTableRowsSerializer().isPresent()) {
            return context.getTableRowsSerializer();
        }
        if (context.getRowsetFormat() == ERowsetFormat.RF_YT_WIRE) {
            Optional<WireRowSerializer<T>> reqSerializer = context.getWireSerializer();
            if (reqSerializer.isPresent()) {
                return Optional.of(new TableRowsWireSerializer<T>(reqSerializer.get()));
            }
            Optional<YTreeSerializer<T>> ysonSerializer = context.getYtreeSerializer();
            if (ysonSerializer.isPresent()) {
                return Optional.of(new TableRowsWireSerializer<T>(serializationResolver.createWireRowSerializer(ysonSerializer.get())));
            }
            return Optional.empty();
        }
        if (context.getRowsetFormat() == ERowsetFormat.RF_FORMAT) {
            if (context.getFormat().isEmpty()) {
                throw new IllegalArgumentException("No format with RF_FORMAT");
            }
            if (context.getSkiffSerializer().isPresent()) {
                return Optional.of(new TableRowsSkiffSerializer<T>(context.getSkiffSerializer().get()));
            }
            if (context.isProtobufFormat()) {
                return Optional.of((TableRowsSerializer)ClassUtils.castToType(new TableRowsProtobufSerializer()));
            }
            if (context.getYtreeSerializer().isEmpty()) {
                throw new IllegalArgumentException("No yson serializer for RF_FORMAT");
            }
            if (!context.getFormat().get().getType().equals(YSON)) {
                throw new IllegalArgumentException("Format " + context.getFormat().get().getType() + " isn't supported");
            }
            YTreeSerializer<T> serializer = context.getYtreeSerializer().get();
            return Optional.of(new TableRowsYsonSerializer<T>(serializer));
        }
        throw new IllegalArgumentException("Unsupported rowset format");
    }

    static <T> byte[] serializeRowsWithDescriptor(TableRowsSerializer<T> serializer, TRowsetDescriptor descriptor) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        buf.writeIntLE(2);
        int descriptorSizeIndex = buf.writerIndex();
        buf.writeLongLE(0L);
        TableRowsSerializerUtil.writeDescriptor(buf, descriptor);
        buf.setLongLE(descriptorSizeIndex, (long)(buf.writerIndex() - descriptorSizeIndex - 8));
        int bufSize = buf.readableBytes();
        int serializedRowsSize = serializer.size();
        byte[] result = new byte[bufSize + serializedRowsSize];
        buf.readBytes(result, 0, bufSize);
        if (buf.readableBytes() != 0) {
            throw new IllegalStateException();
        }
        try (InputStream serializedRows = serializer.flush();){
            int readBytes;
            for (int offset = bufSize; offset != result.length && (readBytes = serializedRows.read(result, offset, result.length - offset)) != -1; offset += readBytes) {
            }
        }
        return result;
    }

    private static void writeDescriptor(ByteBuf buf, TRowsetDescriptor descriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CodedOutputStream os = CodedOutputStream.newInstance((OutputStream)byteArrayOutputStream);
        descriptor.writeTo(os);
        os.flush();
        buf.writeBytes(byteArrayOutputStream.toByteArray());
    }
}

