/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.JarsProcessor;
import tech.ytsaurus.client.operations.SingleUploadFromClassPathJarsProcessor;
import tech.ytsaurus.client.request.RequestMiddleware;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.core.JavaOptions;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class YTsaurusClientConfig {
    private final RpcOptions rpcOptions;
    @Nullable
    private final YTreeNode specPatch;
    @Nullable
    private final YTreeNode jobSpecPatch;
    private final YPath tmpDir;
    private final JarsProcessor jarsProcessor;
    private final boolean isLocalMode;
    private final String javaBinary;
    private final List<YPath> layerPaths;
    private final JavaOptions javaOptions;
    private final String version;
    private final Duration operationPingPeriod;
    private final boolean useTLS;
    private final boolean tvmOnly;
    private final boolean ignoreBalancers;
    @Nullable
    private final RequestMiddleware requestMiddleware;

    YTsaurusClientConfig(Builder builder) {
        if (builder.rpcOptions == null) {
            throw new IllegalStateException("Expected not null rpcOptions");
        }
        this.rpcOptions = builder.rpcOptions;
        if (builder.jarsProcessor == null) {
            throw new IllegalStateException("jarsProcessor is null");
        }
        this.jarsProcessor = builder.jarsProcessor;
        this.tmpDir = builder.tmpDir;
        this.isLocalMode = builder.isLocalMode;
        this.javaBinary = builder.javaBinary;
        this.layerPaths = builder.layerPaths;
        this.javaOptions = builder.javaOptions;
        this.version = builder.version;
        this.specPatch = builder.specPatch;
        this.jobSpecPatch = builder.jobSpecPatch;
        this.operationPingPeriod = builder.operationPingPeriod;
        this.useTLS = builder.useTLS;
        this.tvmOnly = builder.tvmOnly;
        this.ignoreBalancers = builder.ignoreBalancers;
        this.requestMiddleware = builder.requestMiddleware;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return YTsaurusClientConfig.builder().setRpcOptions(this.rpcOptions).setSpecPatch(this.specPatch).setJobSpecPatch(this.jobSpecPatch).setTmpDir(this.tmpDir).setJarsProcessor(this.jarsProcessor).setIsLocalMode(this.isLocalMode).setJavaBinary(this.javaBinary).setLayerPaths(this.layerPaths).setJavaOptions(this.javaOptions).setVersion(this.version).setOperationPingPeriod(this.operationPingPeriod).setUseTLS(this.useTLS).setTvmOnly(this.tvmOnly).setIgnoreBalancers(this.ignoreBalancers).setRequestMiddleware(this.requestMiddleware);
    }

    public RpcOptions getRpcOptions() {
        return this.rpcOptions;
    }

    public Optional<YTreeNode> getJobSpecPatch() {
        return Optional.ofNullable(this.jobSpecPatch);
    }

    public Optional<YTreeNode> getSpecPatch() {
        return Optional.ofNullable(this.specPatch);
    }

    public YPath getTmpDir() {
        return this.tmpDir;
    }

    public JarsProcessor getJarsProcessor() {
        return this.jarsProcessor;
    }

    public boolean isLocalMode() {
        return this.isLocalMode;
    }

    public String getJavaBinary() {
        return this.javaBinary;
    }

    public List<YPath> getLayerPaths() {
        return this.layerPaths;
    }

    public List<String> getJavaOptions() {
        return this.javaOptions.getOptions();
    }

    public String getVersion() {
        return this.version;
    }

    public Duration getOperationPingPeriod() {
        return this.operationPingPeriod;
    }

    public boolean getUseTLS() {
        return this.useTLS;
    }

    public boolean getTvmOnly() {
        return this.tvmOnly;
    }

    public boolean getIgnoreBalancers() {
        return this.ignoreBalancers;
    }

    @Nullable
    public RequestMiddleware getRequestMiddleware() {
        return this.requestMiddleware;
    }

    private static int getJavaMajorVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null) {
            try {
                String[] versionParts = javaVersion.split("\\.");
                if (versionParts.length == 1) {
                    return Integer.parseInt(versionParts[0]);
                }
                if (versionParts.length > 1) {
                    String p1 = versionParts[0];
                    String p2 = versionParts[1];
                    if (p1.equals("1")) {
                        return Integer.parseInt(p2);
                    }
                    return Integer.parseInt(p1);
                }
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        return 0;
    }

    @NonNullApi
    @NonNullFields
    public static class Builder {
        @Nullable
        private RpcOptions rpcOptions;
        private YPath tmpDir = YPath.simple((String)"//tmp/yt_wrapper/file_storage");
        @Nullable
        private YPath cacheDir = YPath.simple((String)"//tmp/yt_wrapper/file_storage").child("new_cache");
        @Nullable
        private JarsProcessor jarsProcessor;
        private boolean isLocalMode = false;
        private String javaBinary = "/usr/bin/java";
        private List<YPath> layerPaths = Collections.emptyList();
        private JavaOptions javaOptions = JavaOptions.empty();
        private Duration jarsUploadTimeout = Duration.ofMinutes(10L);
        private int fileCacheReplicationFactor = 10;
        private String version = "java-ytsaurus-client@";
        private Duration operationPingPeriod = Duration.ofSeconds(30L);
        @Nullable
        private YTreeNode jobSpecPatch;
        @Nullable
        private YTreeNode specPatch;
        private boolean useTLS = false;
        private boolean tvmOnly = false;
        private boolean ignoreBalancers = false;
        @Nullable
        private RequestMiddleware requestMiddleware;

        public Builder setRpcOptions(RpcOptions rpcOptions) {
            this.rpcOptions = rpcOptions;
            return this;
        }

        public Builder setTmpDir(YPath tmpDir) {
            this.tmpDir = tmpDir;
            return this;
        }

        public Builder setJarsProcessor(JarsProcessor jarsProcessor) {
            this.jarsProcessor = jarsProcessor;
            return this;
        }

        public Builder setIsLocalMode(boolean isLocalMode) {
            this.isLocalMode = isLocalMode;
            return this;
        }

        public Builder setJavaBinary(String javaBinary) {
            this.javaBinary = javaBinary;
            return this;
        }

        public Builder setLayerPaths(List<YPath> layerPaths) {
            this.layerPaths = layerPaths;
            return this;
        }

        public Builder setJavaOptions(JavaOptions javaOptions) {
            this.javaOptions = javaOptions;
            return this;
        }

        public Builder addJavaOption(String javaOption) {
            this.javaOptions.withOption(javaOption);
            return this;
        }

        public Builder setCacheDir(@Nullable YPath cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder setJarsUploadTimeout(Duration jarsUploadTimeout) {
            this.jarsUploadTimeout = jarsUploadTimeout;
            return this;
        }

        public Builder setFileCacheReplicationFactor(int fileCacheReplicationFactor) {
            this.fileCacheReplicationFactor = fileCacheReplicationFactor;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setOperationPingPeriod(Duration operationPingPeriod) {
            this.operationPingPeriod = operationPingPeriod;
            return this;
        }

        public Builder setJobSpecPatch(@Nullable YTreeNode jobSpecPatch) {
            this.jobSpecPatch = jobSpecPatch;
            return this;
        }

        public Builder setSpecPatch(@Nullable YTreeNode specPatch) {
            this.specPatch = specPatch;
            return this;
        }

        public Builder setUseTLS(boolean useTLS) {
            this.useTLS = useTLS;
            return this;
        }

        public Builder setTvmOnly(boolean tvmOnly) {
            this.tvmOnly = tvmOnly;
            return this;
        }

        public Builder setIgnoreBalancers(boolean ignoreBalancers) {
            this.ignoreBalancers = ignoreBalancers;
            return this;
        }

        public Builder setRequestMiddleware(@Nullable RequestMiddleware requestMiddleware) {
            this.requestMiddleware = requestMiddleware;
            return this;
        }

        public Builder withPorto() {
            this.javaOptions = JavaOptions.empty().withOption("-XX:+UseParallelGC");
            int javaMajorVersion = YTsaurusClientConfig.getJavaMajorVersion();
            if (javaMajorVersion >= 21) {
                this.javaBinary = "/opt/jdk21/bin/java";
            } else if (javaMajorVersion >= 17) {
                this.javaBinary = "/opt/jdk17/bin/java";
            } else if (javaMajorVersion >= 15) {
                this.javaBinary = "/opt/jdk15/bin/java";
            } else if (javaMajorVersion >= 11) {
                this.javaBinary = "/opt/jdk11/bin/java";
            }
            this.layerPaths = List.of(YPath.simple((String)"//porto_layers/delta/jdk/layer_with_jdk_lastest.tar.gz"), YPath.simple((String)"//porto_layers/base/focal/porto_layer_search_ubuntu_focal_app_lastest.tar.gz"));
            this.specPatch = YTree.builder().beginMap().key("scheduling_tag_filter").value("porto").endMap().build();
            return this;
        }

        public YTsaurusClientConfig build() {
            if (this.rpcOptions == null) {
                this.rpcOptions = new RpcOptions();
            }
            if (this.jarsProcessor == null) {
                this.jarsProcessor = new SingleUploadFromClassPathJarsProcessor(this.tmpDir.child("jars"), this.cacheDir, false, this.jarsUploadTimeout, this.fileCacheReplicationFactor);
            }
            return new YTsaurusClientConfig(this);
        }
    }
}

