/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import tech.ytsaurus.client.bus.BusPacketFixedHeader;
import tech.ytsaurus.client.bus.BusPacketType;
import tech.ytsaurus.client.bus.BusPacketVariableHeader;
import tech.ytsaurus.client.bus.BusUtil;
import tech.ytsaurus.core.GUID;

class BusPacket {
    public static final int PACKET_SIGNATURE = 2019650895;
    public static final int MAX_PART_COUNT = 0x10000000;
    public static final long NULL_CHECKSUM = 0L;
    public static final int MAX_PART_SIZE = 0x10000000;
    public static final int NULL_PART_SIZE = -1;
    private final BusPacketType type;
    private final short flags;
    private final GUID packetId;
    private final List<byte[]> message;

    BusPacket(BusPacketType type, short flags, GUID packetId) {
        this(type, flags, packetId, Collections.emptyList());
    }

    BusPacket(BusPacketType type, short flags, GUID packetId, List<byte[]> message) {
        this.type = Objects.requireNonNull(type);
        this.flags = flags;
        this.packetId = Objects.requireNonNull(packetId);
        this.message = Objects.requireNonNull(message);
    }

    public BusPacketType getType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public GUID getPacketId() {
        return this.packetId;
    }

    public List<byte[]> getMessage() {
        return this.message;
    }

    public boolean hasFlags(short flags) {
        return (this.flags & flags) == flags;
    }

    public int getHeadersSize() {
        int headersSize = 36;
        if (this.type == BusPacketType.MESSAGE) {
            headersSize += BusPacketVariableHeader.size(this.message.size());
        }
        return headersSize;
    }

    public void writeHeadersTo(ByteBuf out, boolean computeChecksums) {
        new BusPacketFixedHeader(this.type, this.flags, this.packetId, this.message.size()).writeTo(out, computeChecksums);
        if (this.type == BusPacketType.MESSAGE) {
            BusPacketVariableHeader.writeTo(this.message, out, computeChecksums);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("BusPacket{\n").append("    type=").append((Object)this.type).append(",\n").append("    flags=").append(this.flags).append(",\n").append("    packetId=").append(this.packetId);
        for (int i = 0; i < this.message.size(); ++i) {
            sb.append(",\n    message[").append(i).append("]=");
            byte[] part = this.message.get(i);
            if (part != null) {
                sb.append('{');
                BusUtil.encodeHex(sb, part);
                sb.append('}');
                continue;
            }
            sb.append("null");
        }
        sb.append('}');
        return sb.toString();
    }
}

