/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import tech.ytsaurus.client.bus.BusListener;
import tech.ytsaurus.client.bus.BusPacketDecoder;
import tech.ytsaurus.client.bus.BusPacketEncoder;
import tech.ytsaurus.client.bus.BusProtocolHandler;
import tech.ytsaurus.client.bus.DefaultBusChannel;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolder;
import tech.ytsaurus.client.bus.DefaultBusChannelMetricsHolderImpl;

class DefaultBusInitializer
extends ChannelInitializer<Channel> {
    private final BusListener listener;
    private Duration readTimeout = Duration.ZERO;
    private Duration writeTimeout = Duration.ZERO;
    private boolean verifyChecksums = false;
    private boolean calculateChecksums = false;
    private final DefaultBusChannelMetricsHolder metricsHolder;

    DefaultBusInitializer(BusListener listener) {
        this(listener, DefaultBusChannelMetricsHolderImpl.INSTANCE);
    }

    DefaultBusInitializer(BusListener listener, DefaultBusChannelMetricsHolder metricsHolder) {
        this.listener = listener;
        this.metricsHolder = metricsHolder;
    }

    public DefaultBusInitializer setReadTimeout(Duration readTimeout) {
        this.readTimeout = Objects.requireNonNull(readTimeout);
        return this;
    }

    public DefaultBusInitializer setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = Objects.requireNonNull(writeTimeout);
        return this;
    }

    public DefaultBusInitializer setVerifyChecksums(boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
        return this;
    }

    public DefaultBusInitializer setCalculateChecksums(boolean calculateChecksums) {
        this.calculateChecksums = calculateChecksums;
        return this;
    }

    protected void initChannel(Channel channel) throws Exception {
        long writeTimeoutNanos;
        DefaultBusChannel bus = DefaultBusChannel.getOrCreateInstance(channel, this.metricsHolder);
        ChannelPipeline pipeline = channel.pipeline();
        long readTimeoutNanos = this.readTimeout.toNanos();
        if (readTimeoutNanos > 0L) {
            pipeline.addLast("read-timeout", (ChannelHandler)new ReadTimeoutHandler(readTimeoutNanos, TimeUnit.NANOSECONDS));
        }
        if ((writeTimeoutNanos = this.writeTimeout.toNanos()) > 0L) {
            pipeline.addLast("write-timeout", (ChannelHandler)new WriteTimeoutHandler(writeTimeoutNanos, TimeUnit.NANOSECONDS));
        }
        pipeline.addLast("decoder", (ChannelHandler)new BusPacketDecoder(this.verifyChecksums)).addLast("encoder", (ChannelHandler)new BusPacketEncoder(this.calculateChecksums)).addLast("handler", (ChannelHandler)new BusProtocolHandler(bus, this.listener));
    }
}

