/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.bus;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.bus.BusServer;
import tech.ytsaurus.client.bus.BusServerLifecycle;
import tech.ytsaurus.client.bus.BusUtil;

public class DefaultBusServerChannel
implements BusServer,
BusServerLifecycle {
    private final ServerChannel channel;
    private final ChannelPromise bound;

    public DefaultBusServerChannel(ServerChannel channel) {
        this.channel = Objects.requireNonNull(channel);
        this.bound = channel.newPromise();
        this.bound.setUncancellable();
    }

    @Override
    public ServerChannel channel() {
        return this.channel;
    }

    @Override
    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    @Override
    public ChannelFuture bound() {
        return this.bound;
    }

    @Override
    public ChannelFuture closed() {
        return this.channel.closeFuture();
    }

    @Override
    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    @Override
    public CompletableFuture<Void> close() {
        return BusUtil.makeCompletableFuture(this.channel.close());
    }

    @Override
    public void listenSucceeded() {
        this.bound.trySuccess();
    }

    @Override
    public void listenFailed(Throwable cause) {
        this.bound.tryFailure(cause);
    }
}

