/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.client.request.Format;
import tech.ytsaurus.client.rows.EntitySkiffSerializer;
import tech.ytsaurus.client.rows.EntityTableSchemaCreator;
import tech.ytsaurus.client.rows.SchemaConverter;
import tech.ytsaurus.core.operations.CloseableIterator;
import tech.ytsaurus.core.operations.OperationContext;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.skiff.SkiffParser;
import tech.ytsaurus.skiff.SkiffSchema;
import tech.ytsaurus.skiff.SkiffSerializer;
import tech.ytsaurus.skiff.WireType;
import tech.ytsaurus.ysontree.YTreeStringNode;

public class EntityTableEntryType<T>
implements YTableEntryType<T> {
    private static final byte[] FIRST_TABLE_INDEX = new byte[]{0, 0};
    private final Class<T> entityClass;
    private final SkiffSchema entitySchema;
    private final TableSchema tableSchema;
    private final boolean trackIndices;
    private final boolean isInputType;

    public EntityTableEntryType(Class<T> entityClass, boolean trackIndices, boolean isInputType) {
        this.entityClass = entityClass;
        this.tableSchema = EntityTableSchemaCreator.create(entityClass);
        this.entitySchema = SchemaConverter.toSkiffSchema(this.tableSchema);
        if (trackIndices) {
            this.entitySchema.getChildren().add(SkiffSchema.variant8(List.of(SkiffSchema.nothing(), SkiffSchema.simpleType((WireType)WireType.INT_64))).setName("$row_index"));
        }
        this.trackIndices = trackIndices;
        this.isInputType = isInputType;
    }

    @Override
    public YTreeStringNode format(FormatContext context) {
        int tableCount = this.isInputType ? context.getInputTableCount().orElseThrow(IllegalArgumentException::new) : context.getOutputTableCount().orElseThrow(IllegalArgumentException::new);
        return Format.skiff(this.entitySchema, tableCount).toTree().stringNode();
    }

    @Override
    public CloseableIterator<T> iterator(final InputStream input, final OperationContext context) {
        context.withSettingIndices(this.trackIndices, this.trackIndices);
        final SkiffParser parser = new SkiffParser(input);
        return new CloseableIterator<T>(){
            private final EntitySkiffSerializer<T> skiffSerializer;
            long rowIndex;
            short tableIndex;
            {
                this.skiffSerializer = new EntitySkiffSerializer(EntityTableEntryType.this.entityClass);
                this.rowIndex = 0L;
                this.tableIndex = 0;
            }

            public boolean hasNext() {
                return parser.hasMoreData();
            }

            public T next() {
                this.tableIndex = parser.parseInt16();
                Object object = this.skiffSerializer.deserialize(parser).orElseThrow(NoSuchElementException::new);
                if (EntityTableEntryType.this.trackIndices) {
                    ++this.rowIndex;
                    if (parser.parseVariant8Tag() != 0) {
                        this.rowIndex = parser.parseInt64();
                    }
                    context.setRowIndex(this.rowIndex);
                    context.setTableIndex((long)this.tableIndex);
                }
                return object;
            }

            public void close() throws Exception {
                input.close();
            }
        };
    }

    @Override
    public Yield<T> yield(OutputStream[] output) {
        final SkiffSerializer[] skiffSerializers = new SkiffSerializer[output.length];
        for (int i = 0; i < output.length; ++i) {
            skiffSerializers[i] = new SkiffSerializer((OutputStream)new BufferedOutputStream(output[i], 65536));
        }
        return new Yield<T>(){
            private final EntitySkiffSerializer<T> entitySerializer;
            {
                this.entitySerializer = new EntitySkiffSerializer(EntityTableEntryType.this.entityClass);
            }

            public void yield(int index, T value) {
                skiffSerializers[index].write(FIRST_TABLE_INDEX);
                this.entitySerializer.serialize(value, skiffSerializers[index]);
            }

            public void close() throws IOException {
                for (SkiffSerializer serializer : skiffSerializers) {
                    serializer.flush();
                    serializer.close();
                }
            }
        };
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }
}

