/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
public class FailedJobInfo {
    private final GUID jobId;
    private final List<String> errorMessages = new ArrayList<String>();
    @Nullable
    private String stderr;

    public FailedJobInfo(GUID jobId) {
        this.jobId = jobId;
    }

    public GUID getJobId() {
        return this.jobId;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Optional<String> getStderr() {
        return Optional.ofNullable(this.stderr);
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public void addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public String toString() {
        String errorMessagesStr = this.errorMessages.stream().map(e -> "- " + e).collect(Collectors.joining("\n"));
        return "Job id: " + this.jobId + "\nError message:\n" + errorMessagesStr + "\nJob stderr: " + this.stderr;
    }
}

