/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.TableWriterOptions;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class JobIo {
    private final boolean enableTableIndex;
    private final boolean enableRowIndex;
    @Nullable
    private final TableWriterOptions tableWriter;

    public JobIo() {
        this(JobIo.builder());
    }

    public JobIo(TableWriterOptions tableWriter) {
        this((BuilderBase)JobIo.builder().setTableWriter(tableWriter));
    }

    protected <T extends BuilderBase<T>> JobIo(BuilderBase<T> builder) {
        this.enableTableIndex = builder.enableTableIndex;
        this.enableRowIndex = builder.enableRowIndex;
        this.tableWriter = builder.tableWriter;
    }

    public Optional<TableWriterOptions> getTableWriter() {
        return Optional.ofNullable(this.tableWriter);
    }

    public boolean isEnableTableIndex() {
        return this.enableTableIndex;
    }

    public boolean isEnableRowIndex() {
        return this.enableRowIndex;
    }

    public BuilderBase<?> toBuilder() {
        Object result = ((BuilderBase)JobIo.builder().setEnableRowIndex(this.isEnableRowIndex())).setEnableTableIndex(this.isEnableTableIndex());
        if (this.getTableWriter().isPresent()) {
            ((BuilderBase)result).setTableWriter(TableWriterOptions.builder().setMaxRowWeight(this.getTableWriter().get().getMaxRowWeight().orElse(null)).setBlockSize(this.getTableWriter().get().getBlockSize().orElse(null)).setDesiredChunkSize(this.getTableWriter().get().getDesiredChunkSize().orElse(null)).build());
        }
        return result;
    }

    public YTreeMapNode prepare() {
        return YTree.mapBuilder().when(this.tableWriter != null, b -> b.key("table_writer").value((YTreeNode)this.tableWriter.prepare())).when(this.enableTableIndex || this.enableRowIndex, b -> b.key("control_attributes").beginMap().key("enable_table_index").value(this.enableTableIndex).key("enable_row_index").value(this.enableRowIndex).endMap()).buildMap();
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>> {
        private boolean enableTableIndex = false;
        private boolean enableRowIndex = false;
        @Nullable
        private TableWriterOptions tableWriter;

        public JobIo build() {
            return new JobIo(this);
        }

        public T setEnableTableIndex(boolean enableTableIndex) {
            this.enableTableIndex = enableTableIndex;
            return this.self();
        }

        public T setEnableRowIndex(boolean enableRowIndex) {
            this.enableRowIndex = enableRowIndex;
            return this.self();
        }

        public T setTableWriter(@Nullable TableWriterOptions tableWriter) {
            this.tableWriter = tableWriter;
            return this.self();
        }

        protected abstract T self();
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

