/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.EntityTableEntryType;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.MapperOrReducerSpec;
import tech.ytsaurus.client.operations.MapperSpec;
import tech.ytsaurus.client.operations.ReducerSpec;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.UserJobSpec;
import tech.ytsaurus.client.operations.UserOperationSpecBase;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.tables.SortColumn;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class MapReduceSpec
extends UserOperationSpecBase
implements Spec {
    private final List<String> reduceBy;
    private final List<SortColumn> sortBy;
    @Nullable
    private final UserJobSpec mapperSpec;
    @Nullable
    private final UserJobSpec reduceCombinerSpec;
    private final UserJobSpec reducerSpec;
    @Nullable
    private final Integer mapJobCount;
    @Nullable
    private final Integer partitionCount;
    @Nullable
    private final Integer partitionJobCount;
    @Nullable
    private final DataSize dataSizePerSortJob;
    @Nullable
    private final Integer mapperOutputTableCount;
    @Nullable
    private final JobIo mapJobIo;
    @Nullable
    private final JobIo sortJobIo;
    @Nullable
    private final JobIo reduceJobIo;

    protected <T extends BuilderBase<T>> MapReduceSpec(BuilderBase<T> builder) {
        super(builder);
        TableSchema outputTableSchema;
        MapperOrReducerSpec mapperOrReducerSpec;
        this.reduceBy = builder.reduceBy;
        this.sortBy = builder.sortBy;
        this.mapperSpec = builder.mapperSpec;
        this.reduceCombinerSpec = builder.reduceCombinerSpec;
        if (builder.reducerSpec == null) {
            throw new RuntimeException("reducerSpec is not specified");
        }
        this.reducerSpec = builder.reducerSpec;
        this.mapJobCount = builder.mapJobCount;
        this.partitionCount = builder.partitionCount;
        this.partitionJobCount = builder.partitionJobCount;
        this.dataSizePerSortJob = builder.dataSizePerSortJob;
        this.mapperOutputTableCount = builder.mapperOutputTableCount;
        if (this.mapperSpec instanceof MapperOrReducerSpec) {
            mapperOrReducerSpec = (MapperOrReducerSpec)this.mapperSpec;
            this.mapJobIo = mapperOrReducerSpec.createJobIo(builder.mapJobIo);
            if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() == EntityTableEntryType.class) {
                outputTableSchema = ((EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType()).getTableSchema();
                this.getOutputTables().subList(0, this.getMapperOutputTableCount().orElse(0)).replaceAll(yPath -> yPath.withSchema(outputTableSchema.toYTree()));
            }
        } else {
            this.mapJobIo = builder.mapJobIo;
        }
        this.reduceJobIo = builder.reduceJobIo;
        if (this.reducerSpec instanceof MapperOrReducerSpec) {
            mapperOrReducerSpec = (MapperOrReducerSpec)this.reducerSpec;
            if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() == EntityTableEntryType.class) {
                outputTableSchema = ((EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType()).getTableSchema();
                this.getOutputTables().subList(this.getMapperOutputTableCount().orElse(0), this.getOutputTables().size()).replaceAll(yPath -> yPath.withSchema(outputTableSchema.toYTree()));
            }
        }
        this.sortJobIo = builder.sortJobIo;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapReduceSpec spec = (MapReduceSpec)obj;
        return this.reduceBy.equals(spec.reduceBy) && this.sortBy.equals(spec.sortBy) && Optional.ofNullable(this.mapperSpec).equals(Optional.ofNullable(spec.mapperSpec)) && Optional.ofNullable(this.reduceCombinerSpec).equals(Optional.ofNullable(spec.reduceCombinerSpec)) && this.reducerSpec.equals(spec.reducerSpec) && Optional.ofNullable(this.mapJobCount).equals(Optional.ofNullable(spec.mapJobCount)) && Optional.ofNullable(this.partitionCount).equals(Optional.ofNullable(spec.partitionCount)) && Optional.ofNullable(this.partitionJobCount).equals(Optional.ofNullable(spec.partitionJobCount)) && Optional.ofNullable(this.dataSizePerSortJob).equals(Optional.ofNullable(spec.dataSizePerSortJob)) && Optional.ofNullable(this.mapperOutputTableCount).equals(Optional.ofNullable(spec.mapperOutputTableCount)) && Optional.ofNullable(this.mapJobIo).equals(Optional.ofNullable(spec.mapJobIo)) && Optional.ofNullable(this.sortJobIo).equals(Optional.ofNullable(spec.sortJobIo)) && Optional.ofNullable(this.reduceJobIo).equals(Optional.ofNullable(spec.reduceJobIo));
    }

    public Optional<Integer> getMapJobCount() {
        return Optional.ofNullable(this.mapJobCount);
    }

    public Optional<Integer> getPartitionCount() {
        return Optional.ofNullable(this.partitionCount);
    }

    public Optional<Integer> getPartitionJobCount() {
        return Optional.ofNullable(this.partitionJobCount);
    }

    public Optional<DataSize> getDataSizePerSortJob() {
        return Optional.ofNullable(this.dataSizePerSortJob);
    }

    public Optional<Integer> getMapperOutputTableCount() {
        return Optional.ofNullable(this.mapperOutputTableCount);
    }

    public Optional<UserJobSpec> getMapperSpec() {
        return Optional.ofNullable(this.mapperSpec);
    }

    public List<String> getSortBy() {
        return this.sortBy.stream().map(SortColumn::getName).collect(Collectors.toList());
    }

    public List<SortColumn> getSortByColumns() {
        return this.sortBy;
    }

    public List<String> getReduceBy() {
        return this.reduceBy;
    }

    public Optional<UserJobSpec> getReduceCombinerSpec() {
        return Optional.ofNullable(this.reduceCombinerSpec);
    }

    public UserJobSpec getReducerSpec() {
        return this.reducerSpec;
    }

    public Optional<JobIo> getMapJobIo() {
        return Optional.ofNullable(this.mapJobIo);
    }

    public Optional<JobIo> getSortJobIo() {
        return Optional.ofNullable(this.sortJobIo);
    }

    public Optional<JobIo> getReduceJobIo() {
        return Optional.ofNullable(this.reduceJobIo);
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), this.getOutputTables(), this.getOutputTableAttributes());
        ArrayList titles = new ArrayList();
        if (this.mapperSpec != null) {
            Optional<String> mapperTitle = SpecUtils.getMapperOrReducerTitle(this.mapperSpec);
            mapperTitle.ifPresent(s -> titles.add(new Title("mapper", (String)s)));
        }
        Optional<String> reducerTitle = SpecUtils.getMapperOrReducerTitle(this.reducerSpec);
        reducerTitle.ifPresent(s -> titles.add(new Title("reducer", (String)s)));
        if (this.reduceCombinerSpec != null) {
            Optional<String> reduceCombinerTitle = SpecUtils.getMapperOrReducerTitle(this.reduceCombinerSpec);
            reduceCombinerTitle.ifPresent(s -> titles.add(new Title("reduce-combiner", (String)s)));
        }
        String title = titles.isEmpty() ? null : (titles.size() == 1 ? ((Title)titles.get((int)0)).title : titles.stream().map(Title::toString).collect(Collectors.joining(", ")));
        FormatContext.Builder mapperFormatContextBuilder = FormatContext.builder().setInputTableCount(this.getInputTables().size()).setOutputTableCount(1 + Optional.ofNullable(this.mapperOutputTableCount).orElse(0));
        this.setOutputStreamsOfMapper(mapperFormatContextBuilder);
        FormatContext mapperFormatContext = mapperFormatContextBuilder.build();
        FormatContext reducerFormatContext = FormatContext.builder().setInputTableCount(1).setOutputTableCount(this.getOutputTables().size() - Optional.ofNullable(this.mapperOutputTableCount).orElse(0)).build();
        FormatContext.Builder reduceCombinerFormatContextBuilder = FormatContext.builder().setInputTableCount(1).setOutputTableCount(1);
        this.setOutputStreamsOfReduceCombiner(reduceCombinerFormatContextBuilder);
        FormatContext reduceCombinerFormatContext = reduceCombinerFormatContextBuilder.build();
        return builder.beginMap().when(title != null, b -> b.key("title").value(title)).when(this.mapJobCount != null, b -> b.key("map_job_count").value(this.mapJobCount)).when(this.partitionCount != null, b -> b.key("partition_count").value(this.partitionCount)).when(this.partitionJobCount != null, b -> b.key("partition_job_count").value(this.partitionJobCount)).when(this.dataSizePerSortJob != null, b -> b.key("data_size_per_sort_job").value(Objects.requireNonNull(this.dataSizePerSortJob).toBytes())).when(this.mapperSpec != null, b -> b.key("mapper").apply(b2 -> Objects.requireNonNull(this.mapperSpec).prepare((YTreeBuilder)b2, yt, specPreparationContext, mapperFormatContext))).key("sort_by").value(this.sortBy, (b, t) -> t.toTree(b)).key("reduce_by").value(this.reduceBy).key("reducer").apply(b -> this.reducerSpec.prepare((YTreeBuilder)b, yt, specPreparationContext, reducerFormatContext)).when(this.reduceCombinerSpec != null, b -> b.key("reduce_combiner").apply(b2 -> Objects.requireNonNull(this.reduceCombinerSpec).prepare((YTreeBuilder)b2, yt, specPreparationContext, reduceCombinerFormatContext))).key("started_by").apply(b -> SpecUtils.startedBy(b, specPreparationContext)).when(this.mapperOutputTableCount != null, b -> b.key("mapper_output_table_count").value(this.mapperOutputTableCount)).when(this.mapJobIo != null, b -> b.key("map_job_io").value((YTreeNode)Objects.requireNonNull(this.mapJobIo).prepare())).when(this.sortJobIo != null, b -> b.key("sort_job_io").value((YTreeNode)Objects.requireNonNull(this.sortJobIo).prepare())).when(this.reduceJobIo != null, b -> b.key("reduce_job_io").value((YTreeNode)Objects.requireNonNull(this.reduceJobIo).prepare())).apply(b -> this.toTree((YTreeBuilder)b, specPreparationContext)).endMap();
    }

    private void setOutputStreamsOfMapper(FormatContext.Builder mapperFormatContextBuilder) {
        if (!(this.mapperSpec instanceof MapperOrReducerSpec)) {
            return;
        }
        MapperOrReducerSpec mapperOrReducerSpec = (MapperOrReducerSpec)this.mapperSpec;
        if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() != EntityTableEntryType.class) {
            return;
        }
        EntityTableEntryType mapperOutputType = (EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType();
        mapperFormatContextBuilder.setOutputStreams(new YTreeBuilder().value((Collection)Stream.generate(() -> new YTreeBuilder().beginMap().key("schema").value(mapperOutputType.getTableSchema().toBuilder().sortBy(this.sortBy.stream().map(SortColumn::getName).collect(Collectors.toList())).build().toYTree()).endMap().build()).limit(1 + Optional.ofNullable(this.mapperOutputTableCount).orElse(0)).collect(Collectors.toList())).build());
    }

    private void setOutputStreamsOfReduceCombiner(FormatContext.Builder reduceCombinerContextBuilder) {
        if (!(this.reduceCombinerSpec instanceof MapperOrReducerSpec)) {
            return;
        }
        MapperOrReducerSpec mapperOrReducerSpec = (MapperOrReducerSpec)this.reduceCombinerSpec;
        if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() != EntityTableEntryType.class) {
            return;
        }
        EntityTableEntryType reduceCombinerOutputType = (EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType();
        reduceCombinerContextBuilder.setOutputStreams(new YTreeBuilder().value((Collection)Stream.generate(() -> new YTreeBuilder().beginMap().key("schema").value(reduceCombinerOutputType.getTableSchema().toYTree()).endMap().build()).limit(1L).collect(Collectors.toList())).build());
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    private static class Title {
        final String name;
        final String title;

        Title(String name, String title) {
            this.name = name;
            this.title = title;
        }

        public String toString() {
            return this.name + ": " + this.title;
        }
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends UserOperationSpecBase.Builder<T> {
        private List<String> reduceBy = new ArrayList<String>();
        private List<SortColumn> sortBy = new ArrayList<SortColumn>();
        @Nullable
        private UserJobSpec mapperSpec;
        @Nullable
        private UserJobSpec reduceCombinerSpec;
        @Nullable
        private UserJobSpec reducerSpec;
        @Nullable
        private Integer mapJobCount;
        @Nullable
        private Integer partitionCount;
        @Nullable
        private Integer partitionJobCount;
        @Nullable
        private DataSize dataSizePerSortJob;
        @Nullable
        private Integer mapperOutputTableCount;
        @Nullable
        private JobIo mapJobIo;
        @Nullable
        private JobIo sortJobIo;
        @Nullable
        private JobIo reduceJobIo;

        public MapReduceSpec build() {
            return new MapReduceSpec(this);
        }

        public T setReduceBy(List<String> reduceBy) {
            this.reduceBy = new ArrayList<String>(reduceBy);
            return (T)((BuilderBase)this.self());
        }

        public T setReduceBy(String ... reduceBy) {
            return this.setReduceBy(Arrays.asList(reduceBy));
        }

        public T setSortByColumns(List<SortColumn> sortBy) {
            this.sortBy = new ArrayList<SortColumn>(sortBy);
            return (T)((BuilderBase)this.self());
        }

        public T setSortByColumns(SortColumn ... sortBy) {
            return this.setSortByColumns(Arrays.asList(sortBy));
        }

        public T setSortBy(List<String> sortBy) {
            return this.setSortByColumns(SortColumn.convert(sortBy));
        }

        public T setSortBy(String ... sortBy) {
            return this.setSortBy(Arrays.asList(sortBy));
        }

        public T setMapperSpec(@Nullable UserJobSpec mapperSpec) {
            this.mapperSpec = mapperSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setMapperSpec(@Nullable MapperSpec mapperSpec) {
            this.mapperSpec = mapperSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setReduceCombinerSpec(@Nullable UserJobSpec reduceCombinerSpec) {
            this.reduceCombinerSpec = reduceCombinerSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setReduceCombinerSpec(@Nullable ReducerSpec reduceCombinerSpec) {
            this.reduceCombinerSpec = reduceCombinerSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setReducerSpec(UserJobSpec reducerSpec) {
            this.reducerSpec = reducerSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setReducerSpec(ReducerSpec reducerSpec) {
            this.reducerSpec = reducerSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setMapJobCount(@Nullable Integer mapJobCount) {
            this.mapJobCount = mapJobCount;
            return (T)((BuilderBase)this.self());
        }

        public T setPartitionCount(@Nullable Integer partitionCount) {
            this.partitionCount = partitionCount;
            return (T)((BuilderBase)this.self());
        }

        public T setPartitionJobCount(@Nullable Integer partitionJobCount) {
            this.partitionJobCount = partitionJobCount;
            return (T)((BuilderBase)this.self());
        }

        public T setDataSizePerSortJob(@Nullable DataSize dataSizePerSortJob) {
            this.dataSizePerSortJob = dataSizePerSortJob;
            return (T)((BuilderBase)this.self());
        }

        public T setMapperOutputTableCount(@Nullable Integer mapperOutputTableCount) {
            this.mapperOutputTableCount = mapperOutputTableCount;
            return (T)((BuilderBase)this.self());
        }

        public T setMapJobIo(@Nullable JobIo mapJobIo) {
            this.mapJobIo = mapJobIo;
            return (T)((BuilderBase)this.self());
        }

        public T setSortJobIo(@Nullable JobIo sortJobIo) {
            this.sortJobIo = sortJobIo;
            return (T)((BuilderBase)this.self());
        }

        public T setReduceJobIo(@Nullable JobIo reduceJobIo) {
            this.reduceJobIo = reduceJobIo;
            return (T)((BuilderBase)this.self());
        }
    }

    @NonNullApi
    @NonNullFields
    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

