/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.CommandSpec;
import tech.ytsaurus.client.operations.EntityTableEntryType;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.Mapper;
import tech.ytsaurus.client.operations.MapperOrReducerSpec;
import tech.ytsaurus.client.operations.MapperSpec;
import tech.ytsaurus.client.operations.SimpleUserOperationSpecBase;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.UserJobSpec;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class MapSpec
extends SimpleUserOperationSpecBase
implements Spec {
    private final UserJobSpec mapperSpec;
    @Nullable
    private final JobIo jobIo;

    public MapSpec(List<YPath> inputTables, List<YPath> outputTables, String command) {
        this((BuilderBase)((BuilderBase)((BuilderBase)MapSpec.builder().setInputTables(inputTables)).setOutputTables(outputTables)).setMapperCommand(command));
    }

    public MapSpec(List<YPath> inputTables, List<YPath> outputTables, Mapper<?, ?> mapper) {
        this((BuilderBase)((BuilderBase)((BuilderBase)MapSpec.builder().setInputTables(inputTables)).setOutputTables(outputTables)).setMapperSpec(new MapperSpec(mapper)));
    }

    public MapSpec(List<YPath> inputTables, List<YPath> outputTables, UserJobSpec mapperSpec) {
        this((BuilderBase)((BuilderBase)((BuilderBase)MapSpec.builder().setInputTables(inputTables)).setOutputTables(outputTables)).setMapperSpec(mapperSpec));
    }

    protected <T extends BuilderBase<T>> MapSpec(BuilderBase<T> builder) {
        super((SimpleUserOperationSpecBase.Builder<?>)builder);
        if (builder.mapperSpec == null) {
            throw new RuntimeException("mapper is not set");
        }
        this.mapperSpec = builder.mapperSpec;
        if (this.mapperSpec instanceof MapperOrReducerSpec) {
            MapperOrReducerSpec mapperOrReducerSpec = (MapperOrReducerSpec)this.mapperSpec;
            this.jobIo = mapperOrReducerSpec.createJobIo(builder.jobIo);
            if (mapperOrReducerSpec.mapperOrReducer.outputType().getClass() == EntityTableEntryType.class) {
                TableSchema outputTableSchema = ((EntityTableEntryType)mapperOrReducerSpec.mapperOrReducer.outputType()).getTableSchema();
                this.getOutputTables().replaceAll(yPath -> yPath.withSchema(outputTableSchema.toYTree()));
            }
        } else {
            this.jobIo = builder.jobIo;
        }
    }

    public Optional<JobIo> getJobIo() {
        return Optional.ofNullable(this.jobIo);
    }

    public UserJobSpec getMapperSpec() {
        return this.mapperSpec;
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), this.getOutputTables(), this.getOutputTableAttributes());
        FormatContext formatContext = FormatContext.builder().setInputTableCount(this.getInputTables().size()).setOutputTableCount(this.getOutputTables().size()).build();
        return builder.beginMap().apply(b -> SpecUtils.addMapperOrReducerTitle(b, this.mapperSpec)).key("mapper").apply(b -> this.mapperSpec.prepare((YTreeBuilder)b, yt, specPreparationContext, formatContext)).when(this.jobIo != null, b -> b.key("job_io").value((YTreeNode)this.jobIo.prepare())).apply(b -> this.dumpToSpec((YTreeBuilder)b, specPreparationContext)).endMap();
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends SimpleUserOperationSpecBase.Builder<T> {
        @Nullable
        private UserJobSpec mapperSpec;
        @Nullable
        private JobIo jobIo;

        protected BuilderBase() {
        }

        public MapSpec build() {
            return new MapSpec(this);
        }

        public T setMapperSpec(UserJobSpec mapperSpec) {
            this.mapperSpec = mapperSpec;
            return (T)((BuilderBase)this.self());
        }

        public T setMapperCommand(String command) {
            return this.setMapperSpec(new CommandSpec(command));
        }

        public T setJobIo(@Nullable JobIo jobIo) {
            this.jobIo = jobIo;
            return (T)((BuilderBase)this.self());
        }
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

