/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.UserOperationSpecBase;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;

@NonNullApi
@NonNullFields
public class SimpleUserOperationSpecBase
extends UserOperationSpecBase {
    @Nullable
    private final Integer jobCount;
    @Nullable
    private final DataSize maxDataSizePerJob;
    @Nullable
    private final DataSize dataSizePerJob;

    protected SimpleUserOperationSpecBase(Builder<?> builder) {
        super(builder);
        this.jobCount = builder.jobCount;
        this.dataSizePerJob = builder.dataSizePerJob;
        this.maxDataSizePerJob = builder.maxDataSizePerJob;
    }

    public Optional<Integer> getJobCount() {
        return Optional.ofNullable(this.jobCount);
    }

    public Optional<DataSize> getMaxDataSizePerJob() {
        return Optional.ofNullable(this.maxDataSizePerJob);
    }

    public Optional<DataSize> getDataSizePerJob() {
        return Optional.ofNullable(this.dataSizePerJob);
    }

    protected YTreeBuilder dumpToSpec(YTreeBuilder mapBuilder, SpecPreparationContext context) {
        return mapBuilder.key("started_by").apply(b -> SpecUtils.startedBy(b, context)).when(this.jobCount != null, b -> b.key("job_count").value(this.jobCount)).when(this.maxDataSizePerJob != null, b -> b.key("max_data_size_per_job").value(this.maxDataSizePerJob.toBytes())).when(this.dataSizePerJob != null, b -> b.key("data_size_per_job").value(this.dataSizePerJob.toBytes())).apply(b -> this.toTree((YTreeBuilder)b, context));
    }

    @NonNullApi
    @NonNullFields
    protected static abstract class Builder<T extends Builder<T>>
    extends UserOperationSpecBase.Builder<T> {
        @Nullable
        private Integer jobCount;
        @Nullable
        private DataSize maxDataSizePerJob;
        @Nullable
        private DataSize dataSizePerJob;

        protected Builder() {
        }

        public T setJobCount(@Nullable Integer jobCount) {
            this.jobCount = jobCount;
            return (T)((Builder)this.self());
        }

        public T setMaxDataSizePerJob(@Nullable DataSize maxDataSizePerJob) {
            this.maxDataSizePerJob = maxDataSizePerJob;
            return (T)((Builder)this.self());
        }

        public T setDataSizePerJob(@Nullable DataSize dataSizePerJob) {
            this.dataSizePerJob = dataSizePerJob;
            return (T)((Builder)this.self());
        }
    }
}

