/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.JobIo;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.client.operations.SystemOperationSpecBase;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.SortColumn;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class SortSpec
extends SystemOperationSpecBase
implements Spec {
    private final List<SortColumn> sortBy;
    @Nullable
    private final Integer partitionCount;
    @Nullable
    private final Integer partitionJobCount;
    @Nullable
    private final DataSize dataSizePerSortJob;
    @Nullable
    private final DataSize dataSizePerSortedMergeJob;
    @Nullable
    private final JobIo mergeJobIo;

    public SortSpec(List<YPath> inputTables, YPath outputTable, List<String> sortBy) {
        this((BuilderBase)((BuilderBase)((BuilderBase)SortSpec.builder().setInputTables(inputTables)).setOutputTable(outputTable)).setSortBy(sortBy));
    }

    protected <T extends BuilderBase<T>> SortSpec(BuilderBase<T> builder) {
        super(builder);
        if (builder.sortBy.isEmpty()) {
            throw new RuntimeException("sortBy is not specified");
        }
        this.sortBy = builder.sortBy;
        this.partitionCount = builder.partitionCount;
        this.partitionJobCount = builder.partitionJobCount;
        this.dataSizePerSortJob = builder.dataSizePerSortJob;
        this.dataSizePerSortedMergeJob = builder.dataSizePerSortedMergeJob;
        this.mergeJobIo = builder.mergeJobIo;
    }

    public Optional<Integer> getPartitionCount() {
        return Optional.ofNullable(this.partitionCount);
    }

    public Optional<Integer> getPartitionJobCount() {
        return Optional.ofNullable(this.partitionJobCount);
    }

    public Optional<DataSize> getDataSizePerSortJob() {
        return Optional.ofNullable(this.dataSizePerSortJob);
    }

    public Optional<DataSize> getDataSizePerSortedMergeJob() {
        return Optional.ofNullable(this.dataSizePerSortedMergeJob);
    }

    public Optional<JobIo> getMergeJobIo() {
        return Optional.ofNullable(this.mergeJobIo);
    }

    public List<String> getSortBy() {
        return this.sortBy.stream().map(SortColumn::getName).collect(Collectors.toList());
    }

    public List<SortColumn> getSortByColumns() {
        return this.sortBy;
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        SpecUtils.createOutputTables(yt, specPreparationContext.getTransactionalOptions().orElse(null), List.of(this.getOutputTable()), this.getOutputTableAttributes());
        return builder.beginMap().when(this.partitionCount != null, b -> b.key("partition_count").value(this.partitionCount)).when(this.partitionJobCount != null, b -> b.key("partition_job_count").value(this.partitionJobCount)).when(this.dataSizePerSortJob != null, b -> b.key("data_size_per_sort_job").value(Objects.requireNonNull(this.dataSizePerSortJob).toBytes())).when(this.dataSizePerSortedMergeJob != null, b -> b.key("data_size_per_sorted_merge_job").value(Objects.requireNonNull(this.dataSizePerSortedMergeJob).toBytes())).key("sort_by").value(this.sortBy, (b, t) -> t.toTree(b)).when(this.mergeJobIo != null, b -> b.key("merge_job_io").value((YTreeNode)Objects.requireNonNull(this.mergeJobIo).prepare())).apply(b -> this.toTree((YTreeBuilder)b, specPreparationContext)).endMap();
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>>
    extends SystemOperationSpecBase.Builder<T> {
        private List<SortColumn> sortBy = new ArrayList<SortColumn>();
        @Nullable
        private Integer partitionCount;
        @Nullable
        private Integer partitionJobCount;
        @Nullable
        private DataSize dataSizePerSortJob;
        @Nullable
        private DataSize dataSizePerSortedMergeJob;
        @Nullable
        private JobIo mergeJobIo;

        public SortSpec build() {
            return new SortSpec(this);
        }

        public T setSortByColumns(List<SortColumn> sortBy) {
            this.sortBy = new ArrayList<SortColumn>(sortBy);
            return (T)((BuilderBase)this.self());
        }

        public T setSortByColumns(SortColumn ... sortBy) {
            return this.setSortByColumns(Arrays.asList(sortBy));
        }

        public T setSortBy(Collection<String> sortBy) {
            return this.setSortByColumns(SortColumn.convert(sortBy));
        }

        public T setSortBy(String ... sortBy) {
            return this.setSortBy(Arrays.asList(sortBy));
        }

        public T setPartitionCount(@Nullable Integer partitionCount) {
            this.partitionCount = partitionCount;
            return (T)((BuilderBase)this.self());
        }

        public T setPartitionJobCount(@Nullable Integer partitionJobCount) {
            this.partitionJobCount = partitionJobCount;
            return (T)((BuilderBase)this.self());
        }

        public T setDataSizePerSortJob(@Nullable DataSize dataSizePerSortJob) {
            this.dataSizePerSortJob = dataSizePerSortJob;
            return (T)((BuilderBase)this.self());
        }

        public T setDataSizePerSortedMergeJob(@Nullable DataSize dataSizePerSortedMergeJob) {
            this.dataSizePerSortedMergeJob = dataSizePerSortedMergeJob;
            return (T)((BuilderBase)this.self());
        }

        public T setMergeJobIo(@Nullable JobIo mergeJobIo) {
            this.mergeJobIo = mergeJobIo;
            return (T)((BuilderBase)this.self());
        }
    }

    protected static class Builder
    extends BuilderBase<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

