/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.Statistics;
import tech.ytsaurus.client.operations.YTableEntryTypes;
import tech.ytsaurus.client.operations.YtUtils;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeMapNode;

@NonNullApi
@NonNullFields
public class StatisticsImpl
implements Statistics {
    private static final int STATISTICS_FILE_DESCRIPTOR_NUMBER = 5;
    @Nullable
    private Yield<YTreeMapNode> yield = null;
    private long jobStartTime = 0L;
    @Nullable
    private String jobName;

    @Override
    public void start(String jobName) {
        this.jobStartTime = System.currentTimeMillis();
        this.jobName = jobName;
    }

    @Override
    public void finish() {
        if (this.jobName != null) {
            long delta = System.currentTimeMillis() - this.jobStartTime;
            this.write(YTree.builder().beginMap().key(this.jobName).beginMap().key("total_time").value(delta).endMap().endMap().build().mapNode());
        }
    }

    @Override
    public void write(YTreeMapNode metricsDict) {
        if (this.yield == null) {
            try {
                BufferedOutputStream output = new BufferedOutputStream(YtUtils.outputStreamById(5));
                this.yield = YTableEntryTypes.yson(false).yield(new OutputStream[]{output});
            }
            catch (FileNotFoundException e) {
                this.yield = null;
            }
        }
        if (this.yield != null) {
            this.yield.yield((Object)metricsDict);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.yield != null) {
            this.yield.close();
        }
    }
}

