/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeMapNode;

@NonNullApi
@NonNullFields
public class TableWriterOptions {
    @Nullable
    private final DataSize maxRowWeight;
    @Nullable
    private final DataSize blockSize;
    @Nullable
    private final DataSize desiredChunkSize;

    TableWriterOptions(Builder builder) {
        this.maxRowWeight = builder.maxRowWeight;
        this.blockSize = builder.blockSize;
        this.desiredChunkSize = builder.desiredChunkSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<DataSize> getMaxRowWeight() {
        return Optional.ofNullable(this.maxRowWeight);
    }

    public Optional<DataSize> getBlockSize() {
        return Optional.ofNullable(this.blockSize);
    }

    public Optional<DataSize> getDesiredChunkSize() {
        return Optional.ofNullable(this.desiredChunkSize);
    }

    public YTreeMapNode prepare() {
        return YTree.mapBuilder().when(this.maxRowWeight != null, b -> b.key("max_row_weight").value(this.maxRowWeight.toBytes())).when(this.blockSize != null, b -> b.key("block_size").value(this.blockSize.toBytes())).when(this.desiredChunkSize != null, b -> b.key("desired_chunk_size").value(this.desiredChunkSize.toBytes())).buildMap();
    }

    @NonNullApi
    @NonNullFields
    public static class Builder {
        @Nullable
        private DataSize maxRowWeight;
        @Nullable
        private DataSize blockSize;
        @Nullable
        private DataSize desiredChunkSize;

        Builder() {
        }

        public Builder setMaxRowWeight(@Nullable DataSize maxRowWeight) {
            this.maxRowWeight = maxRowWeight;
            return this;
        }

        public Builder setBlockSize(@Nullable DataSize blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder setDesiredChunkSize(@Nullable DataSize desiredChunkSize) {
            this.desiredChunkSize = desiredChunkSize;
            return this;
        }

        public TableWriterOptions build() {
            return new TableWriterOptions(this);
        }
    }
}

