/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.WireProtocolWriter;
import tech.ytsaurus.core.tables.TableSchema;

public abstract class AbstractLookupRequest<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends AbstractLookupRequest<TBuilder, TRequest>>
extends RequestBase<TBuilder, TRequest> {
    protected final String path;
    protected final TableSchema schema;
    protected final List<String> lookupColumns;
    protected boolean keepMissingRows;
    protected final List<UnversionedRow> filters;
    protected final List<List<?>> unconvertedFilters;

    protected AbstractLookupRequest(Builder<?, ?> builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.schema = Objects.requireNonNull(builder.schema);
        if (!this.schema.isLookupSchema()) {
            throw new IllegalArgumentException("LookupRowsRequest requires a lookup schema");
        }
        this.lookupColumns = new ArrayList<String>((Collection)Objects.requireNonNull(builder.lookupColumns));
        this.keepMissingRows = builder.keepMissingRows;
        this.unconvertedFilters = new ArrayList(builder.unconvertedFilters);
        this.filters = new ArrayList<UnversionedRow>(builder.filters);
    }

    public void convertValues(SerializationResolver serializationResolver) {
        this.filters.addAll(this.unconvertedFilters.stream().map(filter -> this.convertFilterToRow((List<?>)filter, serializationResolver)).collect(Collectors.toList()));
        this.unconvertedFilters.clear();
    }

    private UnversionedRow convertFilterToRow(List<?> filter, SerializationResolver serializationResolver) {
        if (filter.size() != this.schema.getColumns().size()) {
            throw new IllegalArgumentException("Number of filter columns must match the number key columns");
        }
        ArrayList<UnversionedValue> row = new ArrayList<UnversionedValue>(this.schema.getColumns().size());
        ApiServiceUtil.convertKeyColumns(row, this.schema, filter, serializationResolver);
        return new UnversionedRow(row);
    }

    public void serializeRowsetTo(List<byte[]> attachments) {
        WireProtocolWriter writer = new WireProtocolWriter(attachments);
        writer.writeUnversionedRowset(this.filters, new UnversionedRowSerializer(this.getSchema()));
        writer.finish();
    }

    public String getPath() {
        return this.path;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public boolean getKeepMissingRows() {
        return this.keepMissingRows;
    }

    public List<String> getLookupColumns() {
        return Collections.unmodifiableList(this.lookupColumns);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("Path: ").append(this.path).append("; ");
        sb.append("Schema: ").append(this.schema).append("; ");
        sb.append("LookupColumns: ").append(this.lookupColumns).append("; ");
        super.writeArgumentsLogString(sb);
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends AbstractLookupRequest<?, TRequest>>
    extends RequestBase.Builder<TBuilder, TRequest> {
        @Nullable
        private String path;
        @Nullable
        private TableSchema schema;
        private final List<String> lookupColumns = new ArrayList<String>();
        private boolean keepMissingRows = false;
        protected final List<List<?>> unconvertedFilters = new ArrayList();
        protected final List<UnversionedRow> filters = new ArrayList<UnversionedRow>();

        public TBuilder setPath(String path) {
            this.path = path;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setSchema(TableSchema schema) {
            this.schema = schema;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setKeepMissingRows(boolean keepMissingRows) {
            this.keepMissingRows = keepMissingRows;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder addLookupColumn(String name) {
            this.lookupColumns.add(name);
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder addLookupColumns(List<String> names) {
            this.lookupColumns.addAll(names);
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder addLookupColumns(String ... names) {
            return this.addLookupColumns(Arrays.asList(names));
        }

        public String getPath() {
            return Objects.requireNonNull(this.path);
        }

        public boolean getKeepMissingRows() {
            return this.keepMissingRows;
        }

        public TableSchema getSchema() {
            return Objects.requireNonNull(this.schema);
        }

        public List<String> getLookupColumns() {
            return Collections.unmodifiableList(this.lookupColumns);
        }
    }
}

