/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.request.AbstractLookupRequest;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.ReplicaConsistency;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpcproxy.TReqLookupRows;
import tech.ytsaurus.rpcproxy.TReqVersionedLookupRows;

public abstract class AbstractLookupRowsRequest<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends AbstractLookupRowsRequest<TBuilder, TRequest>>
extends AbstractLookupRequest<TBuilder, TRequest> {
    @Nullable
    protected final YtTimestamp timestamp;
    @Nullable
    protected final YtTimestamp retentionTimestamp;
    @Nullable
    protected final ReplicaConsistency replicaConsistency;

    protected AbstractLookupRowsRequest(Builder<?, ?> builder) {
        super((AbstractLookupRequest.Builder<?, ?>)builder);
        this.timestamp = builder.timestamp;
        this.retentionTimestamp = builder.retentionTimestamp;
        this.replicaConsistency = builder.replicaConsistency;
    }

    public Optional<YtTimestamp> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<YtTimestamp> getRetentionTimestamp() {
        return Optional.ofNullable(this.retentionTimestamp);
    }

    public Optional<ReplicaConsistency> getReplicaConsistency() {
        return Optional.ofNullable(this.replicaConsistency);
    }

    public HighLevelRequest<TReqLookupRows.Builder> asLookupRowsWritable() {
        return new HighLevelRequest<TReqLookupRows.Builder>(){

            @Override
            public String getArgumentsLogString() {
                return AbstractLookupRowsRequest.this.getArgumentsLogString();
            }

            @Override
            public void writeHeaderTo(TRequestHeader.Builder header) {
                AbstractLookupRowsRequest.this.writeHeaderTo(header);
            }

            @Override
            public void writeTo(RpcClientRequestBuilder<TReqLookupRows.Builder, ?> builder) {
                builder.body().setPath(ByteString.copyFromUtf8((String)AbstractLookupRowsRequest.this.getPath()));
                builder.body().addAllColumns(AbstractLookupRowsRequest.this.getLookupColumns());
                builder.body().setKeepMissingRows(AbstractLookupRowsRequest.this.getKeepMissingRows());
                if (AbstractLookupRowsRequest.this.getTimestamp().isPresent()) {
                    builder.body().setTimestamp(AbstractLookupRowsRequest.this.getTimestamp().get().getValue());
                }
                if (AbstractLookupRowsRequest.this.getRetentionTimestamp().isPresent()) {
                    builder.body().setRetentionTimestamp(AbstractLookupRowsRequest.this.getRetentionTimestamp().get().getValue());
                }
                if (AbstractLookupRowsRequest.this.getReplicaConsistency().isPresent()) {
                    builder.body().setReplicaConsistency(AbstractLookupRowsRequest.this.getReplicaConsistency().get().getProtoValue());
                }
                builder.body().setRowsetDescriptor(ApiServiceUtil.makeRowsetDescriptor(AbstractLookupRowsRequest.this.getSchema()));
                AbstractLookupRowsRequest.this.serializeRowsetTo(builder.attachments());
            }
        };
    }

    public HighLevelRequest<TReqVersionedLookupRows.Builder> asVersionedLookupRowsWritable() {
        return new HighLevelRequest<TReqVersionedLookupRows.Builder>(){

            @Override
            public String getArgumentsLogString() {
                return AbstractLookupRowsRequest.this.getArgumentsLogString();
            }

            @Override
            public void writeHeaderTo(TRequestHeader.Builder header) {
                AbstractLookupRowsRequest.this.writeHeaderTo(header);
            }

            @Override
            public void writeTo(RpcClientRequestBuilder<TReqVersionedLookupRows.Builder, ?> builder) {
                builder.body().setPath(ByteString.copyFromUtf8((String)AbstractLookupRowsRequest.this.getPath()));
                builder.body().addAllColumns(AbstractLookupRowsRequest.this.getLookupColumns());
                builder.body().setKeepMissingRows(AbstractLookupRowsRequest.this.getKeepMissingRows());
                if (AbstractLookupRowsRequest.this.getTimestamp().isPresent()) {
                    builder.body().setTimestamp(AbstractLookupRowsRequest.this.getTimestamp().get().getValue());
                }
                builder.body().setRowsetDescriptor(ApiServiceUtil.makeRowsetDescriptor(AbstractLookupRowsRequest.this.getSchema()));
                AbstractLookupRowsRequest.this.serializeRowsetTo(builder.attachments());
            }
        };
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends AbstractLookupRowsRequest<?, TRequest>>
    extends AbstractLookupRequest.Builder<TBuilder, TRequest> {
        @Nullable
        private YtTimestamp timestamp;
        @Nullable
        private YtTimestamp retentionTimestamp;
        @Nullable
        private ReplicaConsistency replicaConsistency;

        public TBuilder setTimestamp(@Nullable YtTimestamp timestamp) {
            this.timestamp = timestamp;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setRetentionTimestamp(@Nullable YtTimestamp retentionTimestamp) {
            this.retentionTimestamp = retentionTimestamp;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setReplicaConsistency(@Nullable ReplicaConsistency replicaConsistency) {
            this.replicaConsistency = replicaConsistency;
            return (TBuilder)((Builder)this.self());
        }

        public Optional<YtTimestamp> getTimestamp() {
            return Optional.ofNullable(this.timestamp);
        }

        public Optional<YtTimestamp> getRetentionTimestamp() {
            return Optional.ofNullable(this.retentionTimestamp);
        }

        public Optional<ReplicaConsistency> getReplicaConsistency() {
            return Optional.ofNullable(this.replicaConsistency);
        }
    }
}

