/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.ERowModificationType;
import tech.ytsaurus.rpcproxy.TReqModifyRows;

public abstract class AbstractModifyRowsRequest<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends AbstractModifyRowsRequest<TBuilder, TRequest>>
extends RequestBase<TBuilder, TRequest> {
    protected final String path;
    protected final TableSchema schema;
    @Nullable
    protected Boolean requireSyncReplica;
    protected final List<ERowModificationType> rowModificationTypes;

    protected AbstractModifyRowsRequest(Builder<?, ?> builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.schema = Objects.requireNonNull(builder.schema);
        if (!this.schema.isWriteSchema()) {
            throw new IllegalArgumentException("ModifyRowsRequest requires a write schema");
        }
        this.requireSyncReplica = builder.requireSyncReplica;
        this.rowModificationTypes = new ArrayList<ERowModificationType>(builder.rowModificationTypes);
    }

    public String getPath() {
        return this.path;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public List<ERowModificationType> getRowModificationTypes() {
        return Collections.unmodifiableList(this.rowModificationTypes);
    }

    public Optional<Boolean> getRequireSyncReplica() {
        return Optional.ofNullable(this.requireSyncReplica);
    }

    public abstract void convertValues(SerializationResolver var1);

    public abstract void serializeRowsetTo(RpcClientRequestBuilder<TReqModifyRows.Builder, ?> var1);

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends RequestBase<?, TRequest>>
    extends RequestBase.Builder<TBuilder, TRequest> {
        @Nullable
        protected String path;
        @Nullable
        protected TableSchema schema;
        @Nullable
        protected Boolean requireSyncReplica = null;
        protected final List<ERowModificationType> rowModificationTypes = new ArrayList<ERowModificationType>();

        public TBuilder setPath(String path) {
            this.path = path;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setSchema(TableSchema schema) {
            this.schema = schema;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setRowModificationTypes(List<ERowModificationType> rowModificationTypes) {
            this.rowModificationTypes.addAll(rowModificationTypes);
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder addRowModificationType(ERowModificationType rowModificationType) {
            this.rowModificationTypes.add(rowModificationType);
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setRequireSyncReplica(@Nullable Boolean requireSyncReplica) {
            this.requireSyncReplica = requireSyncReplica;
            return (TBuilder)((Builder)this.self());
        }

        public List<ERowModificationType> getRowModificationTypes() {
            return this.rowModificationTypes;
        }

        public String getPath() {
            return Objects.requireNonNull(this.path);
        }

        public TableSchema getSchema() {
            return Objects.requireNonNull(this.schema);
        }
    }
}

