/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TReqAdvanceQueueConsumer;

public class AdvanceConsumer
extends RequestBase<Builder, AdvanceConsumer>
implements HighLevelRequest<TReqAdvanceQueueConsumer.Builder> {
    @Nullable
    private final GUID transactionId;
    private final YPath consumerPath;
    private final YPath queuePath;
    private final int partitionIndex;
    @Nullable
    private final Long oldOffset;
    private final long newOffset;

    AdvanceConsumer(Builder builder) {
        super(builder);
        this.transactionId = builder.transactionId;
        this.consumerPath = Objects.requireNonNull(builder.consumerPath);
        this.queuePath = Objects.requireNonNull(builder.queuePath);
        this.partitionIndex = Objects.requireNonNull(builder.partitionIndex);
        this.newOffset = Objects.requireNonNull(builder.newOffset);
        this.oldOffset = builder.oldOffset;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AdvanceConsumer.builder();
        builder.transactionId = this.transactionId;
        return (Builder)((Builder)((Builder)((Builder)((Builder)builder.setConsumerPath(this.consumerPath).setQueuePath(this.queuePath).setPartitionIndex(this.partitionIndex).setNewOffset(this.newOffset).setOldOffset(this.oldOffset).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqAdvanceQueueConsumer.Builder, ?> requestBuilder) {
        TReqAdvanceQueueConsumer.Builder builder = requestBuilder.body();
        if (this.transactionId == null) {
            throw new RuntimeException("The AdvanceQueueConsumer request requires a transaction ID");
        }
        builder.setTransactionId(RpcUtil.toProto(this.transactionId));
        builder.setConsumerPath(ByteString.copyFromUtf8((String)this.consumerPath.toString()));
        builder.setQueuePath(ByteString.copyFromUtf8((String)this.queuePath.toString()));
        builder.setPartitionIndex(this.partitionIndex);
        if (this.oldOffset != null) {
            builder.setOldOffset(this.oldOffset.longValue());
        }
        builder.setNewOffset(this.newOffset);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, AdvanceConsumer> {
        @Nullable
        private GUID transactionId;
        @Nullable
        private YPath consumerPath;
        @Nullable
        private YPath queuePath;
        @Nullable
        private Integer partitionIndex;
        @Nullable
        private Long oldOffset;
        @Nullable
        private Long newOffset;

        private Builder() {
        }

        public Builder setTransactionId(GUID transactionId) {
            this.transactionId = transactionId;
            return this.self();
        }

        public Builder setConsumerPath(YPath consumerPath) {
            this.consumerPath = consumerPath;
            return this.self();
        }

        public Builder setQueuePath(YPath queuePath) {
            this.queuePath = queuePath;
            return this.self();
        }

        public Builder setPartitionIndex(int partitionIndex) {
            this.partitionIndex = partitionIndex;
            return this.self();
        }

        public Builder setOldOffset(@Nullable Long oldOffset) {
            this.oldOffset = oldOffset;
            return this.self();
        }

        public Builder setNewOffset(long newOffset) {
            this.newOffset = newOffset;
            return this.self();
        }

        @Override
        public AdvanceConsumer build() {
            return new AdvanceConsumer(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

