/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.TableReq;
import tech.ytsaurus.client.request.TableSchemaModification;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TReqAlterTable;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

public class AlterTable
extends TableReq<Builder, AlterTable>
implements HighLevelRequest<TReqAlterTable.Builder> {
    @Nullable
    private final YTreeNode schemaNode;
    @Nullable
    private final Boolean dynamic;
    @Nullable
    private final GUID upstreamReplicaId;
    @Nullable
    private final TableSchemaModification schemaModification;
    @Nullable
    private final TransactionalOptions transactionalOptions;

    AlterTable(BuilderBase<?> builder) {
        super((TableReq.Builder<?, ?>)builder);
        this.schemaNode = builder.schemaNode;
        this.dynamic = builder.dynamic;
        this.upstreamReplicaId = builder.upstreamReplicaId;
        this.schemaModification = builder.schemaModification;
        this.transactionalOptions = builder.transactionalOptions;
    }

    public AlterTable(YPath path) {
        this((BuilderBase)AlterTable.builder().setPath(path));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqAlterTable.Builder, ?> requestBuilder) {
        TReqAlterTable.Builder builder = requestBuilder.body();
        super.writeTo(builder);
        if (this.schemaNode != null) {
            builder.setSchema(ByteString.copyFrom((byte[])this.schemaNode.toBinary()));
        }
        if (this.dynamic != null) {
            builder.setDynamic(this.dynamic.booleanValue());
        }
        if (this.upstreamReplicaId != null) {
            builder.setUpstreamReplicaId(RpcUtil.toProto(this.upstreamReplicaId));
        }
        if (this.schemaModification != null) {
            builder.setSchemaModification(this.schemaModification.getProtoValue());
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.toProto());
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        if (this.schemaNode != null) {
            sb.append("Schema: ").append(this.schemaNode).append("; ");
        }
        if (this.dynamic != null) {
            sb.append("Dynamic: ").append(this.dynamic).append("; ");
        }
        if (this.upstreamReplicaId != null) {
            sb.append("Upstream replica ID: ").append(this.upstreamReplicaId).append("; ");
        }
        if (this.schemaModification != null) {
            sb.append("Schema modification: ").append((Object)this.schemaModification).append("; ");
        }
    }

    public YTreeBuilder toTree(YTreeBuilder builder) {
        return builder.key("path").apply(arg_0 -> ((YPath)YPath.simple((String)this.getPath())).toTree(arg_0)).when(this.dynamic != null, x -> x.key("dynamic").value(this.dynamic)).when(this.schemaNode != null, x -> x.key("schema").value(this.schemaNode)).when(this.upstreamReplicaId != null, x -> x.key("upstream_replica_id").value(Objects.requireNonNull(this.upstreamReplicaId).toString())).when(this.schemaModification != null, x -> x.key("schema_modification").value(Objects.requireNonNull(this.schemaModification).toString()));
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)AlterTable.builder().setSchema(this.schemaNode)).setDynamic(this.dynamic)).setTransactionalOptions(this.transactionalOptions)).setUpstreamReplicaId(this.upstreamReplicaId)).setSchemaModification(this.schemaModification)).setMutatingOptions(this.mutatingOptions)).setPath(this.path)).setTabletRangeOptions(this.tabletRangeOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends TableReq.Builder<TBuilder, AlterTable> {
        @Nullable
        private YTreeNode schemaNode;
        @Nullable
        private Boolean dynamic;
        @Nullable
        private GUID upstreamReplicaId;
        @Nullable
        private TableSchemaModification schemaModification;
        @Nullable
        private TransactionalOptions transactionalOptions;

        public BuilderBase() {
        }

        public BuilderBase(BuilderBase<?> builder) {
            super((TableReq.Builder<?, ?>)builder);
            if (builder.schemaNode != null) {
                this.schemaNode = YTree.deepCopy((YTreeNode)builder.schemaNode);
            }
            this.dynamic = builder.dynamic;
            this.upstreamReplicaId = builder.upstreamReplicaId;
            this.schemaModification = builder.schemaModification;
            if (builder.transactionalOptions != null) {
                this.transactionalOptions = new TransactionalOptions(builder.transactionalOptions);
            }
        }

        public TBuilder setSchema(@Nullable TableSchema schema) {
            if (schema != null) {
                this.schemaNode = schema.toYTree();
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSchema(@Nullable YTreeNode schema) {
            if (schema != null) {
                this.schemaNode = YTree.deepCopy((YTreeNode)schema);
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setDynamic(@Nullable Boolean dynamic) {
            this.dynamic = dynamic;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setUpstreamReplicaId(@Nullable GUID upstreamReplicaId) {
            this.upstreamReplicaId = upstreamReplicaId;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSchemaModification(@Nullable TableSchemaModification schemaModification) {
            this.schemaModification = schemaModification;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            if (this.schemaNode != null) {
                sb.append("Schema: ").append(this.schemaNode).append("; ");
            }
            if (this.dynamic != null) {
                sb.append("Dynamic: ").append(this.dynamic).append("; ");
            }
            if (this.upstreamReplicaId != null) {
                sb.append("Upstream replica ID: ").append(this.upstreamReplicaId).append("; ");
            }
            if (this.schemaModification != null) {
                sb.append("Schema modification: ").append((Object)this.schemaModification).append("; ");
            }
        }

        public YTreeBuilder toTree(YTreeBuilder builder) {
            return builder.key("path").apply(arg_0 -> ((YPath)YPath.simple((String)this.getPath())).toTree(arg_0)).when(this.dynamic != null, x -> x.key("dynamic").value(this.dynamic)).when(this.schemaNode != null, x -> x.key("schema").value(this.schemaNode)).when(this.upstreamReplicaId != null, x -> x.key("upstream_replica_id").value(this.upstreamReplicaId.toString())).when(this.schemaModification != null, x -> x.key("schema_modification").value(this.schemaModification.toString()));
        }

        @Override
        public AlterTable build() {
            return new AlterTable(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

