/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqBuildSnapshot;

public class BuildSnapshot
extends RequestBase<Builder, BuildSnapshot>
implements HighLevelRequest<TReqBuildSnapshot.Builder> {
    private final GUID cellId;
    private final boolean setReadOnly;

    BuildSnapshot(Builder builder) {
        super(builder);
        this.cellId = Objects.requireNonNull(builder.cellId);
        this.setReadOnly = builder.setReadOnly;
    }

    public BuildSnapshot(GUID cellId) {
        this(BuildSnapshot.builder().setCellId(cellId));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqBuildSnapshot.Builder, ?> builder) {
        builder.body().setCellId(RpcUtil.toProto(this.cellId)).setSetReadOnly(this.setReadOnly);
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("CellId: ").append(this.cellId).append("; SetReadOnly: ").append(this.setReadOnly).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)BuildSnapshot.builder().setCellId(this.cellId).setSetReadOnly(this.setReadOnly).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, BuildSnapshot> {
        @Nullable
        private GUID cellId;
        private boolean setReadOnly = TReqBuildSnapshot.getDefaultInstance().getSetReadOnly();

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.cellId = builder.cellId;
            this.setReadOnly = builder.setReadOnly;
        }

        public Builder setCellId(GUID cellId) {
            this.cellId = cellId;
            return this;
        }

        public Builder setSetReadOnly(boolean setReadOnly) {
            this.setReadOnly = setReadOnly;
            return this;
        }

        @Override
        public BuildSnapshot build() {
            return new BuildSnapshot(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

