/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.MutateNode;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.rpcproxy.TMasterReadOptions;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqCheckPermission;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;

public class CheckPermission
extends MutateNode<Builder, CheckPermission>
implements HighLevelRequest<TReqCheckPermission.Builder> {
    private final String user;
    private final String path;
    private final int permissions;
    private final Set<String> columns;
    @Nullable
    private final MasterReadOptions masterReadOptions;

    CheckPermission(Builder builder) {
        super(builder);
        this.user = Objects.requireNonNull(builder.user);
        this.path = Objects.requireNonNull(builder.path);
        this.permissions = Objects.requireNonNull(builder.permissions);
        this.columns = Objects.requireNonNull(builder.columns);
        this.masterReadOptions = builder.masterReadOptions;
    }

    public CheckPermission(String user, String path, int permissions) {
        this(user, path, permissions, Collections.emptySet());
    }

    public CheckPermission(String user, String path, int permissions, Set<String> columns) {
        this(CheckPermission.builder().setUser(user).setPath(path).setPermissions(permissions).setColumns(columns));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqCheckPermission.Builder, ?> requestBuilder) {
        TReqCheckPermission.Builder builder = requestBuilder.body();
        builder.setUser(this.user).setPath(ByteString.copyFromUtf8((String)this.path)).setPermission(this.permissions).setColumns(TReqCheckPermission.TColumns.newBuilder().addAllItems(this.columns));
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
        if (this.masterReadOptions != null) {
            builder.setMasterReadOptions(this.masterReadOptions.writeTo(TMasterReadOptions.newBuilder()));
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("Path: ").append(this.path).append("; ");
        sb.append("User: ").append(this.user).append("; ");
        sb.append("Permissions: ").append(this.permissions).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)CheckPermission.builder().setUser(this.user).setPath(this.path).setPermissions(this.permissions).setColumns(this.columns).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        builder.setMutatingOptions(new MutatingOptions(this.mutatingOptions));
        if (this.masterReadOptions != null) {
            builder.setMasterReadOptions(new MasterReadOptions(this.masterReadOptions));
        }
        return builder;
    }

    public static class Builder
    extends MutateNode.Builder<Builder, CheckPermission> {
        @Nullable
        private String user;
        @Nullable
        private String path;
        @Nullable
        private Integer permissions;
        @Nullable
        private Set<String> columns = Collections.emptySet();
        @Nullable
        private MasterReadOptions masterReadOptions;

        public Builder setUser(String user) {
            this.user = user;
            return this.self();
        }

        public Builder setPath(String path) {
            this.path = path;
            return this.self();
        }

        public Builder setPermissions(int permissions) {
            this.permissions = permissions;
            return this.self();
        }

        public Builder setColumns(Set<String> columns) {
            this.columns = new HashSet<String>(columns);
            return this.self();
        }

        public Builder setMasterReadOptions(MasterReadOptions masterReadOptions) {
            this.masterReadOptions = masterReadOptions;
            return this.self();
        }

        @Override
        public CheckPermission build() {
            return new CheckPermission(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

