/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MutateNode;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TReqConcatenateNodes;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBuilder;

public class ConcatenateNodes
extends MutateNode<Builder, ConcatenateNodes>
implements HighLevelRequest<TReqConcatenateNodes.Builder> {
    private final List<YPath> sourcePaths;
    private final YPath destinationPath;

    public ConcatenateNodes(BuilderBase<?> builder) {
        super((MutateNode.Builder<?, ?>)builder);
        this.sourcePaths = Objects.requireNonNull(builder.sourcePaths);
        this.destinationPath = Objects.requireNonNull(builder.destinationPath);
    }

    public ConcatenateNodes(String[] from, String to) {
        this(Arrays.stream(from).map(YPath::simple).collect(Collectors.toList()), YPath.simple((String)to));
    }

    public ConcatenateNodes(List<YPath> source, YPath dest) {
        this((BuilderBase<?>)((Builder)ConcatenateNodes.builder().setSourcePaths(source)).setDestinationPath(dest));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<YPath> getSourcePaths() {
        return this.sourcePaths;
    }

    public YPath getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqConcatenateNodes.Builder, ?> requestBuilder) {
        TReqConcatenateNodes.Builder builder = requestBuilder.body();
        for (YPath s : this.sourcePaths) {
            builder.addSrcPaths(ByteString.copyFromUtf8((String)s.toString()));
        }
        builder.setDstPath(ByteString.copyFromUtf8((String)this.destinationPath.toString()));
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        builder.setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("SourcePaths: ").append(Arrays.toString(this.sourcePaths.toArray())).append("; DstPath: ").append(this.destinationPath).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public YTreeBuilder toTree(YTreeBuilder builder) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("source_paths").value(this.sourcePaths, (b2, t) -> t.toTree(b2)).key("destination_path").apply(arg_0 -> ((YPath)this.destinationPath).toTree(arg_0));
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ConcatenateNodes.builder().setSourcePaths(this.sourcePaths)).setDestinationPath(this.destinationPath)).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        builder.setMutatingOptions(new MutatingOptions(this.mutatingOptions));
        return builder;
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends MutateNode.Builder<TBuilder, ConcatenateNodes> {
        @Nullable
        private List<YPath> sourcePaths;
        @Nullable
        private YPath destinationPath;

        protected BuilderBase() {
        }

        protected BuilderBase(BuilderBase<?> builder) {
            super((MutateNode.Builder<?, ?>)builder);
            if (builder.sourcePaths != null) {
                this.sourcePaths = new ArrayList<YPath>(builder.sourcePaths);
            }
            this.destinationPath = builder.destinationPath;
        }

        public TBuilder setSourcePaths(List<YPath> sourcePaths) {
            this.sourcePaths = sourcePaths;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setDestinationPath(YPath destinationPath) {
            this.destinationPath = destinationPath;
            return (TBuilder)((BuilderBase)this.self());
        }

        public List<YPath> getSourcePaths() {
            return Objects.requireNonNull(this.sourcePaths);
        }

        public YPath getDestinationPath() {
            return Objects.requireNonNull(this.destinationPath);
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            Objects.requireNonNull(this.sourcePaths);
            Objects.requireNonNull(this.destinationPath);
            sb.append("SourcePaths: ").append(Arrays.toString(this.sourcePaths.toArray())).append("; DstPath: ").append(this.destinationPath.toString()).append("; ");
            super.writeArgumentsLogString(sb);
        }

        @Override
        public YTreeBuilder toTree(YTreeBuilder builder) {
            Objects.requireNonNull(this.sourcePaths);
            Objects.requireNonNull(this.destinationPath);
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("source_paths").value(this.sourcePaths, (b2, t) -> t.toTree(b2)).key("destination_path").apply(arg_0 -> ((YPath)this.destinationPath).toTree(arg_0));
        }

        @Override
        public ConcatenateNodes build() {
            return new ConcatenateNodes(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

