/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.MutateNode;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.ysontree.YTreeBuilder;

public abstract class CopyLikeReq<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends CopyLikeReq<TBuilder, TRequest>>
extends MutateNode<TBuilder, TRequest> {
    protected final String source;
    protected final String destination;
    protected final boolean recursive;
    protected final boolean force;
    protected final boolean preserveAccount;
    protected final boolean preserveExpirationTime;
    protected final boolean preserveCreationTime;
    protected final boolean ignoreExisting;
    @Nullable
    protected final Boolean enableCrossCellCopying;

    protected CopyLikeReq(Builder<?, ?> builder) {
        super((MutateNode.Builder<?, ?>)builder);
        this.source = Objects.requireNonNull(builder.source);
        this.destination = Objects.requireNonNull(builder.destination);
        this.recursive = builder.recursive;
        this.force = builder.force;
        this.preserveAccount = builder.preserveAccount;
        this.preserveExpirationTime = builder.preserveExpirationTime;
        this.preserveCreationTime = builder.preserveCreationTime;
        this.ignoreExisting = builder.ignoreExisting;
        this.enableCrossCellCopying = builder.enableCrossCellCopying;
    }

    public YPath getSource() {
        return YPath.simple((String)this.source);
    }

    public YPath getDestination() {
        return YPath.simple((String)this.destination);
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean getForce() {
        return this.force;
    }

    public boolean getPreserveAccount() {
        return this.preserveAccount;
    }

    public boolean getPreserveExpirationTime() {
        return this.preserveExpirationTime;
    }

    public boolean getPreserveCreationTime() {
        return this.preserveCreationTime;
    }

    public boolean getIgnoreExisting() {
        return this.ignoreExisting;
    }

    public Optional<Boolean> getEnableCrossCellCopying() {
        return Optional.ofNullable(this.enableCrossCellCopying);
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("Source: ").append(this.source).append("; Destination: ").append(this.destination).append("; ");
        if (this.recursive) {
            sb.append("Recursive: true; ");
        }
        if (this.ignoreExisting) {
            sb.append("IgnoreExisting: true; ");
        }
        if (this.force) {
            sb.append("Force: true; ");
        }
        if (this.preserveAccount) {
            sb.append("PreserveAccount: true; ");
        }
        if (this.preserveCreationTime) {
            sb.append("PreserveCreationTime: true; ");
        }
        if (this.preserveExpirationTime) {
            sb.append("PreserveExpirationTime: true; ");
        }
        if (this.enableCrossCellCopying != null) {
            sb.append("EnableCrossCellCopying: ").append(this.enableCrossCellCopying).append("; ");
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public YTreeBuilder toTree(YTreeBuilder builder) {
        return this.toTree(builder, "source_path", "destination_path");
    }

    public YTreeBuilder toTree(YTreeBuilder builder, String sourcePathKey, String destinationPathKey) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key(sourcePathKey).value(this.source).key(destinationPathKey).value(this.destination).key("recursive").value(this.recursive).key("force").value(this.force).key("preserve_account").value(this.preserveAccount).key("preserve_expiration_time").value(this.preserveExpirationTime).key("preserve_creation_time").value(this.preserveCreationTime).key("ignore_existing").value(this.ignoreExisting).when(this.enableCrossCellCopying != null, b -> b.key("enable_cross_cell_copying").value(this.enableCrossCellCopying));
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends MutateNode<?, TRequest>>
    extends MutateNode.Builder<TBuilder, TRequest> {
        @Nullable
        protected String source;
        @Nullable
        protected String destination;
        protected boolean recursive = false;
        protected boolean force = false;
        protected boolean preserveAccount = false;
        protected boolean preserveExpirationTime = false;
        protected boolean preserveCreationTime = false;
        protected boolean ignoreExisting = false;
        @Nullable
        protected Boolean enableCrossCellCopying;

        protected Builder() {
        }

        protected Builder(Builder<?, ?> builder) {
            super((MutateNode.Builder<?, ?>)builder);
            this.source = builder.source;
            this.destination = builder.destination;
            this.recursive = builder.recursive;
            this.force = builder.force;
            this.preserveAccount = builder.preserveAccount;
            this.preserveCreationTime = builder.preserveCreationTime;
            this.preserveExpirationTime = builder.preserveExpirationTime;
            this.ignoreExisting = builder.ignoreExisting;
            this.enableCrossCellCopying = builder.enableCrossCellCopying;
        }

        public TBuilder setSource(String source) {
            this.source = source;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setDestination(String destination) {
            this.destination = destination;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setRecursive(boolean recursive) {
            this.recursive = recursive;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setForce(boolean force) {
            this.force = force;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setPreserveAccount(boolean preserveAccount) {
            this.preserveAccount = preserveAccount;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setPreserveExpirationTime(boolean preserveExpirationTime) {
            this.preserveExpirationTime = preserveExpirationTime;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setPreserveCreationTime(boolean preserveCreationTime) {
            this.preserveCreationTime = preserveCreationTime;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setIgnoreExisting(boolean ignoreExisting) {
            this.ignoreExisting = ignoreExisting;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setEnableCrossCellCopying(@Nullable Boolean enableCrossCellCopying) {
            this.enableCrossCellCopying = enableCrossCellCopying;
            return (TBuilder)((Builder)this.self());
        }

        public YPath getSource() {
            return YPath.simple((String)this.source);
        }

        public YPath getDestination() {
            return YPath.simple((String)this.destination);
        }

        public boolean getRecursive() {
            return this.recursive;
        }

        public boolean getForce() {
            return this.force;
        }

        public boolean getPreserveAccount() {
            return this.preserveAccount;
        }

        public boolean getPreserveExpirationTime() {
            return this.preserveExpirationTime;
        }

        public boolean getPreserveCreationTime() {
            return this.preserveCreationTime;
        }

        public boolean getIgnoreExisting() {
            return this.ignoreExisting;
        }

        public Optional<Boolean> getEnableCrossCellCopying() {
            return Optional.ofNullable(this.enableCrossCellCopying);
        }

        @Override
        public YTreeBuilder toTree(YTreeBuilder builder) {
            return this.toTree(builder, "source_path", "destination_path");
        }

        public YTreeBuilder toTree(YTreeBuilder builder, String sourcePathKey, String destinationPathKey) {
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key(sourcePathKey).value(this.source).key(destinationPathKey).value(this.destination).key("recursive").value(this.recursive).key("force").value(this.force).key("preserve_account").value(this.preserveAccount).key("preserve_expiration_time").value(this.preserveExpirationTime).key("preserve_creation_time").value(this.preserveCreationTime).key("ignore_existing").value(this.ignoreExisting).when(this.enableCrossCellCopying != null, b -> b.key("enable_cross_cell_copying").value(this.enableCrossCellCopying));
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            sb.append("Source: ").append(this.source).append("; Destination: ").append(this.destination).append("; ");
            if (this.recursive) {
                sb.append("Recursive: true; ");
            }
            if (this.ignoreExisting) {
                sb.append("IgnoreExisting: true; ");
            }
            if (this.force) {
                sb.append("Force: true; ");
            }
            if (this.preserveAccount) {
                sb.append("PreserveAccount: true; ");
            }
            if (this.preserveCreationTime) {
                sb.append("PreserveCreationTime: true; ");
            }
            if (this.preserveExpirationTime) {
                sb.append("PreserveExpirationTime: true; ");
            }
            if (this.enableCrossCellCopying != null) {
                sb.append("EnableCrossCellCopying: ").append(this.enableCrossCellCopying).append("; ");
            }
            super.writeArgumentsLogString(sb);
        }
    }
}

