/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MutatePath;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqCreateNode;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ytree.TAttributeDictionary;

public class CreateNode
extends MutatePath<Builder, CreateNode>
implements HighLevelRequest<TReqCreateNode.Builder> {
    private final CypressNodeType type;
    private final boolean recursive;
    private final boolean force;
    private final boolean ignoreExisting;
    private final boolean lockExisting;
    private final Map<String, YTreeNode> attributes;

    public CreateNode(BuilderBase<?> builder) {
        super((MutatePath.Builder<?, ?>)builder);
        this.type = Objects.requireNonNull(builder.type);
        this.recursive = builder.recursive;
        this.force = builder.force;
        this.ignoreExisting = builder.ignoreExisting;
        this.lockExisting = builder.lockExisting;
        this.attributes = new HashMap<String, YTreeNode>(builder.attributes);
    }

    public CreateNode(YPath path, CypressNodeType type) {
        this((BuilderBase<?>)((Builder)CreateNode.builder().setPath(path)).setType(type));
    }

    public CreateNode(YPath path, CypressNodeType type, Map<String, YTreeNode> attributes) {
        this((BuilderBase<?>)((Builder)((Builder)CreateNode.builder().setPath(path)).setType(type)).setAttributes(attributes));
    }

    public static Builder builder() {
        return new Builder();
    }

    public CypressNodeType getType() {
        return this.type;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isIgnoreExisting() {
        return this.ignoreExisting;
    }

    public boolean isLockExisting() {
        return this.lockExisting;
    }

    public Map<String, YTreeNode> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqCreateNode.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.path.toString())).setType(this.type.protoValue()).setRecursive(this.recursive).setForce(this.force).setIgnoreExisting(this.ignoreExisting).setLockExisting(this.lockExisting);
        if (this.transactionalOptions != null) {
            builder.body().setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.body().setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        builder.body().setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
        if (this.additionalData != null) {
            builder.body().mergeFrom(this.additionalData);
        }
        if (!this.attributes.isEmpty()) {
            TAttributeDictionary.Builder aBuilder = builder.body().getAttributesBuilder();
            for (Map.Entry<String, YTreeNode> me : this.attributes.entrySet()) {
                aBuilder.addAttributesBuilder().setKey(me.getKey()).setValue(ByteString.copyFrom((byte[])me.getValue().toBinary()));
            }
        }
    }

    @Override
    public YTreeBuilder toTree(@Nonnull YTreeBuilder builder) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("type").value(this.type.value()).when(this.recursive, b -> b.key("recursive").value(this.recursive)).when(this.ignoreExisting, b -> b.key("ignore_existing").value(this.ignoreExisting)).when(this.lockExisting, b -> b.key("lock_existing").value(this.lockExisting)).when(this.force, b -> b.key("force").value(true)).when(!this.attributes.isEmpty(), b -> b.key("attributes").value(this.attributes));
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("; Type:").append(this.type).append("; ");
        if (this.recursive) {
            sb.append("Recursive: true; ");
        }
        if (this.ignoreExisting) {
            sb.append("IgnoreExisting: true; ");
        }
        if (this.lockExisting) {
            sb.append("LockExisting: true; ");
        }
        if (this.force) {
            sb.append("Force: true; ");
        }
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)CreateNode.builder().setType(this.type)).setForce(this.force)).setIgnoreExisting(this.ignoreExisting)).setRecursive(this.recursive)).setLockExisting(this.lockExisting)).setPath(this.path)).setAttributes(this.attributes)).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData)).setMutatingOptions(new MutatingOptions(this.mutatingOptions));
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends MutatePath.Builder<TBuilder, CreateNode> {
        @Nullable
        protected CypressNodeType type;
        protected boolean recursive = false;
        protected boolean force = false;
        protected boolean ignoreExisting = false;
        protected boolean lockExisting = false;
        protected final Map<String, YTreeNode> attributes = new HashMap<String, YTreeNode>();

        protected BuilderBase() {
        }

        public BuilderBase(BuilderBase<?> builder) {
            super((MutatePath.Builder<?, ?>)builder);
            this.type = builder.type;
            this.recursive = builder.recursive;
            this.force = builder.force;
            this.ignoreExisting = builder.ignoreExisting;
            this.lockExisting = builder.lockExisting;
            this.attributes.clear();
            this.attributes.putAll(builder.attributes);
        }

        public TBuilder setType(CypressNodeType type) {
            this.type = type;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setRecursive(boolean recursive) {
            this.recursive = recursive;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setForce(boolean force) {
            this.force = force;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setIgnoreExisting(boolean ignoreExisting) {
            this.ignoreExisting = ignoreExisting;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setLockExisting(boolean lockExisting) {
            this.lockExisting = lockExisting;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addAttribute(String name, @Nullable Object value) {
            this.attributes.put(name, YTree.node((Object)value));
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addAttribute(String name, YTreeNode value) {
            this.attributes.put(name, value);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAttributes(Map<String, YTreeNode> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder clearAttributes() {
            this.attributes.clear();
            return (TBuilder)((BuilderBase)this.self());
        }

        public CypressNodeType getType() {
            return Objects.requireNonNull(this.type);
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean isForce() {
            return this.force;
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public boolean isLockExisting() {
            return this.lockExisting;
        }

        public Map<String, YTreeNode> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        @Override
        public YTreeBuilder toTree(@Nonnull YTreeBuilder builder) {
            Objects.requireNonNull(this.type);
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("type").value(this.type.value()).when(this.recursive, b -> b.key("recursive").value(this.recursive)).when(this.ignoreExisting, b -> b.key("ignore_existing").value(this.ignoreExisting)).when(this.lockExisting, b -> b.key("lock_existing").value(this.lockExisting)).when(this.force, b -> b.key("force").value(true)).when(!this.attributes.isEmpty(), b -> b.key("attributes").value(this.attributes));
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            sb.append("; Type:").append(this.type).append("; ");
            if (this.recursive) {
                sb.append("Recursive: true; ");
            }
            if (this.ignoreExisting) {
                sb.append("IgnoreExisting: true; ");
            }
            if (this.lockExisting) {
                sb.append("LockExisting: true; ");
            }
            if (this.force) {
                sb.append("Force: true; ");
            }
        }

        @Override
        public CreateNode build() {
            return new CreateNode(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

