/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.CypressNodeType;
import tech.ytsaurus.rpcproxy.TReqCreateObject;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ytree.TAttributeDictionary;

public class CreateObject
extends RequestBase<Builder, CreateObject>
implements HighLevelRequest<TReqCreateObject.Builder> {
    private final CypressNodeType type;
    private final Map<String, YTreeNode> attributes;
    private final boolean ignoreExisting;

    CreateObject(Builder builder) {
        super(builder);
        this.type = Objects.requireNonNull(builder.type);
        this.attributes = new HashMap<String, YTreeNode>(builder.attributes);
        this.ignoreExisting = builder.ignoreExisting;
    }

    public CreateObject(CypressNodeType type) {
        this(CreateObject.builder().setType(type));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqCreateObject.Builder, ?> builder) {
        builder.body().setType(this.type.protoValue());
        builder.body().setIgnoreExisting(this.ignoreExisting);
        TAttributeDictionary.Builder aBuilder = builder.body().getAttributesBuilder();
        for (Map.Entry<String, YTreeNode> me : this.attributes.entrySet()) {
            aBuilder.addAttributesBuilder().setKey(me.getKey()).setValue(ByteString.copyFrom((byte[])me.getValue().toBinary()));
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("Type: ").append(this.type).append("; IgnoreExisting: ").append(this.ignoreExisting).append("; ");
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)CreateObject.builder().setType(this.type).setAttributes(this.attributes).setIgnoreExisting(this.ignoreExisting).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, CreateObject> {
        @Nullable
        private CypressNodeType type;
        private Map<String, YTreeNode> attributes = new HashMap<String, YTreeNode>();
        private boolean ignoreExisting = TReqCreateObject.getDefaultInstance().getIgnoreExisting();

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.attributes = new HashMap<String, YTreeNode>(builder.attributes);
            this.ignoreExisting = builder.ignoreExisting;
        }

        public Builder setType(CypressNodeType type) {
            this.type = type;
            return this.self();
        }

        public Builder addAttribute(String name, YTreeNode value) {
            this.attributes.put(name, value);
            return this.self();
        }

        public Builder setAttributes(Map<String, YTreeNode> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
            return this.self();
        }

        public Builder setIgnoreExisting(boolean ignoreExisting) {
            this.ignoreExisting = ignoreExisting;
            return this.self();
        }

        @Override
        public CreateObject build() {
            return new CreateObject(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

