/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.ShuffleHandle;
import tech.ytsaurus.rpcproxy.TReqReadShuffleData;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class CreateShuffleReader
extends RequestBase<Builder, CreateShuffleReader> {
    private final ShuffleHandle handle;
    private final int partitionIndex;
    @Nullable
    private final YTreeNode config;
    private static final YTreeNode EMPTY_CONFIG = YTree.builder().beginMap().endMap().build();

    public CreateShuffleReader(BuilderBase<?> builder) {
        super(builder);
        this.handle = builder.handle;
        this.partitionIndex = builder.partitionIndex;
        this.config = builder.config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(TReqReadShuffleData.Builder builder) {
        builder.setShuffleHandle(this.handle.getPayload());
        builder.setPartitionIndex(this.partitionIndex);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize((YTreeNode)(this.config == null ? EMPTY_CONFIG : this.config), (OutputStream)baos);
        byte[] data = baos.toByteArray();
        builder.setReaderConfig(ByteString.copyFrom((byte[])data));
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)CreateShuffleReader.builder().setHandle(this.handle)).setPartitionIndex(this.partitionIndex)).setConfig(this.config);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, CreateShuffleReader> {
        private ShuffleHandle handle;
        private int partitionIndex;
        @Nullable
        private YTreeNode config = null;

        public TBuilder setHandle(ShuffleHandle handle) {
            this.handle = handle;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPartitionIndex(int partitionIndex) {
            this.partitionIndex = partitionIndex;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public CreateShuffleReader build() {
            return new CreateShuffleReader(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

