/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.SuppressableAccessTrackingOptions;
import tech.ytsaurus.client.request.TransactionalRequest;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.ysontree.YTreeBuilder;

public abstract class GetLikeReq<TBuilder extends RequestBase.Builder<TBuilder, TRequest>, TRequest extends RequestBase<TBuilder, TRequest>>
extends TransactionalRequest<TBuilder, TRequest> {
    protected YPath path;
    @Nullable
    protected List<String> attributes;
    @Nullable
    protected Integer maxSize;
    @Nullable
    protected MasterReadOptions masterReadOptions;
    @Nullable
    protected SuppressableAccessTrackingOptions suppressableAccessTrackingOptions;

    GetLikeReq(Builder<?, ?> builder) {
        super((TransactionalRequest.Builder<?, ?>)builder);
        Objects.requireNonNull(builder.path);
        this.path = builder.path;
        this.attributes = builder.attributes;
        this.maxSize = builder.maxSize;
        this.masterReadOptions = builder.masterReadOptions;
        this.suppressableAccessTrackingOptions = builder.suppressableAccessTrackingOptions;
    }

    protected GetLikeReq(GetLikeReq<?, ?> getLikeReq) {
        super((TransactionalRequest<?, ?>)getLikeReq);
        Objects.requireNonNull(getLikeReq.path);
        this.path = getLikeReq.path;
        this.attributes = getLikeReq.attributes;
        this.maxSize = getLikeReq.maxSize;
        this.masterReadOptions = getLikeReq.masterReadOptions != null ? new MasterReadOptions(getLikeReq.masterReadOptions) : null;
        this.suppressableAccessTrackingOptions = getLikeReq.suppressableAccessTrackingOptions != null ? new SuppressableAccessTrackingOptions(getLikeReq.suppressableAccessTrackingOptions) : null;
    }

    public YPath getPath() {
        return this.path;
    }

    public Optional<List<String>> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    public Optional<Integer> getMaxSize() {
        return Optional.ofNullable(this.maxSize);
    }

    public Optional<MasterReadOptions> getMasterReadOptions() {
        return Optional.ofNullable(this.masterReadOptions);
    }

    public Optional<SuppressableAccessTrackingOptions> getSuppressableAccessTrackingOptions() {
        return Optional.ofNullable(this.suppressableAccessTrackingOptions);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("Path: ").append(this.path).append("; ");
        if (this.attributes != null) {
            sb.append("Attributes: ").append(this.attributes).append("; ");
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public YTreeBuilder toTree(YTreeBuilder builder) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("path").apply(arg_0 -> ((YPath)this.path).toTree(arg_0)).when(this.masterReadOptions != null, b -> b.key("read_from").apply(this.masterReadOptions::toTree)).when(this.attributes != null, b2 -> b2.key("attributes").value(this.attributes));
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends TransactionalRequest<?, TRequest>>
    extends TransactionalRequest.Builder<TBuilder, TRequest> {
        @Nullable
        protected YPath path;
        @Nullable
        protected List<String> attributes;
        @Nullable
        protected Integer maxSize;
        @Nullable
        protected MasterReadOptions masterReadOptions;
        @Nullable
        protected SuppressableAccessTrackingOptions suppressableAccessTrackingOptions;

        Builder() {
        }

        protected Builder(Builder<?, ?> builder) {
            super((TransactionalRequest.Builder<?, ?>)builder);
            this.path = builder.path;
            this.attributes = builder.attributes;
            this.maxSize = builder.maxSize;
            this.masterReadOptions = builder.masterReadOptions != null ? new MasterReadOptions(builder.masterReadOptions) : null;
            this.suppressableAccessTrackingOptions = builder.suppressableAccessTrackingOptions != null ? new SuppressableAccessTrackingOptions(builder.suppressableAccessTrackingOptions) : null;
        }

        public TBuilder setPath(YPath path) {
            this.path = path.justPath();
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setAttributes(@Nullable List<String> attributes) {
            if (attributes != null) {
                this.attributes = List.copyOf(attributes);
            }
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setMaxSize(@Nullable Integer maxSize) {
            this.maxSize = maxSize;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setMasterReadOptions(@Nullable MasterReadOptions mo) {
            this.masterReadOptions = mo;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setSuppressableAccessTrackingOptions(@Nullable SuppressableAccessTrackingOptions s) {
            this.suppressableAccessTrackingOptions = s;
            return (TBuilder)((Builder)this.self());
        }

        public YPath getPath() {
            Objects.requireNonNull(this.path);
            return this.path;
        }

        public Optional<List<String>> getAttributes() {
            return Optional.ofNullable(this.attributes);
        }

        public Optional<Integer> getMaxSize() {
            return Optional.ofNullable(this.maxSize);
        }

        public Optional<MasterReadOptions> getMasterReadOptions() {
            return Optional.ofNullable(this.masterReadOptions);
        }

        public Optional<SuppressableAccessTrackingOptions> getSuppressableAccessTrackingOptions() {
            return Optional.ofNullable(this.suppressableAccessTrackingOptions);
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            sb.append("Path: ").append(this.path).append("; ");
            if (this.attributes != null) {
                sb.append("Attributes: ").append(this.attributes).append("; ");
            }
            super.writeArgumentsLogString(sb);
        }

        @Override
        public YTreeBuilder toTree(YTreeBuilder builder) {
            Objects.requireNonNull(this.path);
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("path").apply(arg_0 -> ((YPath)this.path).toTree(arg_0)).when(this.masterReadOptions != null, b -> b.key("read_from").apply(this.masterReadOptions::toTree)).when(this.attributes != null, b2 -> b2.key("attributes").value(this.attributes));
        }
    }
}

