/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.OperationReq;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TMasterReadOptions;
import tech.ytsaurus.rpcproxy.TReqGetOperation;

public class GetOperation
extends OperationReq<Builder, GetOperation>
implements HighLevelRequest<TReqGetOperation.Builder> {
    private final List<String> attributes;
    @Nullable
    private final MasterReadOptions masterReadOptions;
    private final boolean includeRuntime;

    public GetOperation(BuilderBase<?> builder) {
        super((OperationReq.Builder<?, ?>)builder);
        this.attributes = new ArrayList<String>(builder.attributes);
        this.masterReadOptions = builder.masterReadOptions != null ? new MasterReadOptions(builder.masterReadOptions) : null;
        this.includeRuntime = builder.includeRuntime;
    }

    public GetOperation(GUID guid) {
        this((BuilderBase)GetOperation.builder().setOperationId(guid));
    }

    public GetOperation(String alias) {
        this((BuilderBase)GetOperation.builder().setOperationAlias(alias));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqGetOperation.Builder, ?> requestBuilder) {
        TReqGetOperation.Builder messageBuilder = requestBuilder.body();
        this.writeOperationDescriptionToProto(arg_0 -> ((TReqGetOperation.Builder)messageBuilder).setOperationId(arg_0), arg_0 -> ((TReqGetOperation.Builder)messageBuilder).setOperationAlias(arg_0));
        messageBuilder.addAllLegacyAttributes(this.attributes).setIncludeRuntime(this.includeRuntime);
        if (this.masterReadOptions != null) {
            messageBuilder.setMasterReadOptions(this.masterReadOptions.writeTo(TMasterReadOptions.newBuilder()));
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        if (!this.attributes.isEmpty()) {
            sb.append("Attributes: ").append(this.attributes).append("; ");
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)GetOperation.builder().setOperationId(this.operationId)).setOperationAlias(this.operationAlias)).setAttributes(new ArrayList<String>(this.attributes))).includeRuntime(this.includeRuntime)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        if (this.masterReadOptions != null) {
            builder.setMasterReadOptions(new MasterReadOptions(this.masterReadOptions));
        }
        return builder;
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends OperationReq.Builder<TBuilder, GetOperation> {
        private List<String> attributes = new ArrayList<String>();
        @Nullable
        private MasterReadOptions masterReadOptions;
        private boolean includeRuntime;

        protected BuilderBase() {
        }

        BuilderBase(BuilderBase<?> builder) {
            super((OperationReq.Builder<?, ?>)builder);
            this.attributes = new ArrayList<String>(builder.attributes);
            if (builder.masterReadOptions != null) {
                this.masterReadOptions = new MasterReadOptions(builder.masterReadOptions);
            }
            this.includeRuntime = builder.includeRuntime;
        }

        public TBuilder setMasterReadOptions(MasterReadOptions masterReadOptions) {
            this.masterReadOptions = masterReadOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder includeRuntime(boolean includeRuntime) {
            this.includeRuntime = includeRuntime;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addAttribute(String attribute) {
            this.attributes.add(attribute);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAttributes(Collection<String> attributes) {
            this.attributes.clear();
            this.attributes.addAll(attributes);
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            if (!this.attributes.isEmpty()) {
                sb.append("Attributes: ").append(this.attributes).append("; ");
            }
            super.writeArgumentsLogString(sb);
        }

        @Override
        public GetOperation build() {
            return new GetOperation(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

