/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.OperationSortDirection;
import tech.ytsaurus.client.request.QueryEngine;
import tech.ytsaurus.client.request.QueryState;
import tech.ytsaurus.client.request.QueryTrackerReq;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.rpcproxy.TReqListQueries;
import tech.ytsaurus.ytree.TAttributeFilter;

public class ListQueries
extends QueryTrackerReq<Builder, ListQueries>
implements HighLevelRequest<TReqListQueries.Builder> {
    @Nullable
    private final Instant fromTime;
    @Nullable
    private final Instant toTime;
    @Nullable
    private final Instant cursorTime;
    private final OperationSortDirection cursorDirection;
    @Nullable
    private final String userFilter;
    @Nullable
    private final QueryState stateFilter;
    @Nullable
    private final QueryEngine engineFilter;
    @Nullable
    private final String substrFilter;
    private final long limit;
    @Nullable
    private final List<String> attributes;

    ListQueries(Builder builder) {
        super(builder);
        this.fromTime = builder.fromTime;
        this.toTime = builder.toTime;
        this.cursorTime = builder.cursorTime;
        this.cursorDirection = Objects.requireNonNull(builder.cursorDirection);
        this.userFilter = builder.userFilter;
        this.stateFilter = builder.stateFilter;
        this.engineFilter = builder.engineFilter;
        this.substrFilter = builder.substrFilter;
        this.limit = builder.limit;
        this.attributes = builder.attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ListQueries.builder().setFromTime(this.fromTime).setToTime(this.toTime).setCursorTime(this.cursorTime).setCursorDirection(this.cursorDirection).setUserFilter(this.userFilter).setStateFilter(this.stateFilter).setEngineFilter(this.engineFilter).setSubstrFilter(this.substrFilter).setLimit(this.limit).setAttributes(this.attributes).setQueryTrackerStage(this.queryTrackerStage)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqListQueries.Builder, ?> requestBuilder) {
        TReqListQueries.Builder builder = requestBuilder.body();
        this.writeQueryTrackerDescriptionToProto(arg_0 -> ((TReqListQueries.Builder)builder).setQueryTrackerStage(arg_0));
        if (this.fromTime != null) {
            builder.setFromTime(RpcUtil.instantToMicros(this.fromTime));
        }
        if (this.toTime != null) {
            builder.setFromTime(RpcUtil.instantToMicros(this.toTime));
        }
        if (this.cursorTime != null) {
            builder.setCursorTime(RpcUtil.instantToMicros(this.cursorTime));
        }
        builder.setCursorDirection(this.cursorDirection.getProtoValue());
        if (this.userFilter != null) {
            builder.setUserFilter(this.userFilter);
        }
        if (this.stateFilter != null) {
            builder.setStateFilter(this.stateFilter.getProtoValue());
        }
        if (this.engineFilter != null) {
            builder.setEngineFilter(this.engineFilter.getProtoValue());
        }
        if (this.substrFilter != null) {
            builder.setSubstrFilter(this.substrFilter);
        }
        builder.setLimit(this.limit);
        if (this.attributes != null) {
            builder.setAttributes(TAttributeFilter.newBuilder().addAllKeys(this.attributes).build());
        }
    }

    public static class Builder
    extends QueryTrackerReq.Builder<Builder, ListQueries> {
        @Nullable
        private Instant fromTime;
        @Nullable
        private Instant toTime;
        @Nullable
        private Instant cursorTime;
        @Nullable
        private OperationSortDirection cursorDirection = OperationSortDirection.Past;
        @Nullable
        private String userFilter;
        @Nullable
        private QueryState stateFilter;
        @Nullable
        private QueryEngine engineFilter;
        @Nullable
        private String substrFilter;
        private long limit = 100L;
        @Nullable
        private List<String> attributes;

        private Builder() {
        }

        public Builder setFromTime(@Nullable Instant fromTime) {
            this.fromTime = fromTime;
            return this.self();
        }

        public Builder setToTime(@Nullable Instant toTime) {
            this.toTime = toTime;
            return this.self();
        }

        public Builder setCursorTime(@Nullable Instant cursorTime) {
            this.cursorTime = cursorTime;
            return this.self();
        }

        public Builder setCursorDirection(OperationSortDirection cursorDirection) {
            this.cursorDirection = cursorDirection;
            return this.self();
        }

        public Builder setUserFilter(@Nullable String userFilter) {
            this.userFilter = userFilter;
            return this.self();
        }

        public Builder setStateFilter(@Nullable QueryState stateFilter) {
            this.stateFilter = stateFilter;
            return this.self();
        }

        public Builder setEngineFilter(@Nullable QueryEngine engineFilter) {
            this.engineFilter = engineFilter;
            return this.self();
        }

        public Builder setSubstrFilter(@Nullable String substrFilter) {
            this.substrFilter = substrFilter;
            return this.self();
        }

        public Builder setLimit(long limit) {
            this.limit = limit;
            return this.self();
        }

        public Builder setAttributes(@Nullable List<String> attributes) {
            this.attributes = attributes;
            return this.self();
        }

        @Override
        public ListQueries build() {
            return new ListQueries(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

