/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.RegistrationPartitions;
import tech.ytsaurus.core.cypress.RichYPath;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TRspListQueueConsumerRegistrations;

public class ListQueueConsumerRegistrationsResult {
    private final List<QueueConsumerRegistration> queueConsumerRegistrations;

    public ListQueueConsumerRegistrationsResult(TRspListQueueConsumerRegistrations rsp) {
        this.queueConsumerRegistrations = rsp.getRegistrationsList().stream().map(QueueConsumerRegistration::new).collect(Collectors.toUnmodifiableList());
    }

    public List<QueueConsumerRegistration> getQueueConsumerRegistrations() {
        return this.queueConsumerRegistrations;
    }

    public static class QueueConsumerRegistration {
        private final YPath queuePath;
        private final YPath consumerPath;
        private final boolean vital;
        @Nullable
        private final RegistrationPartitions partitions;

        public QueueConsumerRegistration(TRspListQueueConsumerRegistrations.TQueueConsumerRegistration protoValue) {
            this.queuePath = RichYPath.fromString((String)protoValue.getQueuePath().toStringUtf8());
            this.consumerPath = RichYPath.fromString((String)protoValue.getConsumerPath().toStringUtf8());
            this.vital = protoValue.getVital();
            this.partitions = protoValue.hasPartitions() ? new RegistrationPartitions(protoValue.getPartitions().getItemsList()) : null;
        }

        public YPath getQueuePath() {
            return this.queuePath;
        }

        public YPath getConsumerPath() {
            return this.consumerPath;
        }

        public boolean isVital() {
            return this.vital;
        }

        public Optional<RegistrationPartitions> getPartitions() {
            return Optional.ofNullable(this.partitions);
        }
    }
}

