/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MutatePath;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.request.LockMode;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqLockNode;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBuilder;

public class LockNode
extends MutatePath<Builder, LockNode>
implements HighLevelRequest<TReqLockNode.Builder> {
    private final LockMode mode;
    private final boolean waitable;
    @Nullable
    private final String childKey;
    @Nullable
    private final String attributeKey;

    public LockNode(BuilderBase<?> builder) {
        super((MutatePath.Builder<?, ?>)builder);
        this.mode = Objects.requireNonNull(builder.mode);
        this.waitable = builder.waitable;
        this.childKey = builder.childKey;
        this.attributeKey = builder.attributeKey;
    }

    public LockNode(YPath path, LockMode mode) {
        this((BuilderBase<?>)((Builder)LockNode.builder().setPath(path)).setMode(mode));
    }

    public static Builder builder() {
        return new Builder();
    }

    public LockMode getMode() {
        return this.mode;
    }

    public boolean isWaitable() {
        return this.waitable;
    }

    public Optional<String> getChildKey() {
        return Optional.ofNullable(this.childKey);
    }

    public Optional<String> getAttributeKey() {
        return Optional.ofNullable(this.attributeKey);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqLockNode.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.path.toString())).setMode(this.mode.getProtoValue()).setWaitable(this.waitable);
        if (this.childKey != null) {
            builder.body().setChildKey(this.childKey);
        }
        if (this.attributeKey != null) {
            builder.body().setAttributeKey(this.attributeKey);
        }
        if (this.transactionalOptions != null) {
            builder.body().setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.body().setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        builder.body().setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
        if (this.additionalData != null) {
            builder.body().mergeFrom(this.additionalData);
        }
    }

    @Override
    public YTreeBuilder toTree(@Nonnull YTreeBuilder builder) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("mode").value(this.mode.getWireName()).when(this.waitable, b -> b.key("waitable").value(true)).when(this.childKey != null, b -> b.key("child_key").value(this.childKey)).when(this.attributeKey != null, b -> b.key("attribute_key").value(this.attributeKey));
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("Mode: ").append(this.mode).append("; ");
        if (this.waitable) {
            sb.append("Waitable: true; ");
        }
        if (this.childKey != null) {
            sb.append("ChildKey: ").append(this.childKey).append("; ");
        }
        if (this.attributeKey != null) {
            sb.append("AttributeKey: ").append(this.attributeKey).append("; ");
        }
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)LockNode.builder().setPath(this.path)).setMode(this.mode)).setWaitable(this.waitable)).setChildKey(this.childKey)).setAttributeKey(this.attributeKey)).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData)).setMutatingOptions(new MutatingOptions(this.mutatingOptions));
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends MutatePath.Builder<TBuilder, LockNode> {
        @Nullable
        private LockMode mode;
        private boolean waitable = false;
        @Nullable
        private String childKey;
        @Nullable
        private String attributeKey;

        protected BuilderBase() {
        }

        protected BuilderBase(BuilderBase<?> builder) {
            super((MutatePath.Builder<?, ?>)builder);
            this.mode = builder.mode;
            this.waitable = builder.waitable;
            this.childKey = builder.childKey;
            this.attributeKey = builder.attributeKey;
        }

        public TBuilder setMode(LockMode mode) {
            this.mode = mode;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWaitable(boolean waitable) {
            this.waitable = waitable;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setChildKey(@Nullable String childKey) {
            this.childKey = childKey;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAttributeKey(@Nullable String attributeKey) {
            this.attributeKey = attributeKey;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public YTreeBuilder toTree(@Nonnull YTreeBuilder builder) {
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).key("mode").value(Objects.requireNonNull(this.mode).getWireName()).when(this.waitable, b -> b.key("waitable").value(true)).when(this.childKey != null, b -> b.key("child_key").value(this.childKey)).when(this.attributeKey != null, b -> b.key("attribute_key").value(this.attributeKey));
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            sb.append("Mode: ").append(this.mode).append("; ");
            if (this.waitable) {
                sb.append("Waitable: true; ");
            }
            if (this.childKey != null) {
                sb.append("ChildKey: ").append(this.childKey).append("; ");
            }
            if (this.attributeKey != null) {
                sb.append("AttributeKey: ").append(this.attributeKey).append("; ");
            }
        }

        public LockMode getMode() {
            return Objects.requireNonNull(this.mode);
        }

        public boolean isWaitable() {
            return this.waitable;
        }

        public Optional<String> getChildKey() {
            return Optional.ofNullable(this.childKey);
        }

        public Optional<String> getAttributeKey() {
            return Optional.ofNullable(this.attributeKey);
        }

        @Override
        public LockNode build() {
            return new LockNode(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

