/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.ysontree.YTreeBuilder;

public class PrerequisiteOptions {
    @Nullable
    private List<GUID> transactionsIds;
    @Nullable
    private List<RevisionPrerequisite> revisions;

    public PrerequisiteOptions() {
    }

    public PrerequisiteOptions(PrerequisiteOptions prerequisiteOptions) {
        this.transactionsIds = prerequisiteOptions.transactionsIds;
        this.revisions = prerequisiteOptions.revisions;
    }

    public PrerequisiteOptions setTransactionsIds(List<GUID> transactionIds) {
        this.transactionsIds = new ArrayList<GUID>(transactionIds);
        return this;
    }

    public PrerequisiteOptions setTransactionsIds(GUID ... transactionsIds) {
        this.transactionsIds = Arrays.asList(transactionsIds);
        return this;
    }

    public PrerequisiteOptions setRevisions(RevisionPrerequisite ... revisions) {
        this.revisions = Arrays.asList(revisions);
        return this;
    }

    public YTreeBuilder toTree(YTreeBuilder builder) {
        if (this.transactionsIds != null && !this.transactionsIds.isEmpty()) {
            builder.key("prerequisite_transaction_ids").value((Collection)this.transactionsIds.stream().map(GUID::toString).collect(Collectors.toList()));
        }
        if (this.revisions != null && !this.revisions.isEmpty()) {
            throw new IllegalArgumentException("revisions prerequisites are not supported yet");
        }
        return builder;
    }

    public TPrerequisiteOptions.Builder writeTo(TPrerequisiteOptions.Builder builder) {
        if (this.transactionsIds != null) {
            for (GUID guid : this.transactionsIds) {
                builder.addTransactions(TPrerequisiteOptions.TTransactionPrerequisite.newBuilder().setTransactionId(RpcUtil.toProto(guid)).build());
            }
        }
        if (this.revisions != null) {
            for (RevisionPrerequisite rev : this.revisions) {
                builder.addRevisions(TPrerequisiteOptions.TRevisionPrerequisite.newBuilder().setPath(ByteString.copyFromUtf8((String)rev.path)).setRevision(rev.revision).build());
            }
        }
        return builder;
    }

    public static class RevisionPrerequisite {
        private final String path;
        private final long revision;

        public RevisionPrerequisite(String path, long revision) {
            this.path = path;
            this.revision = revision;
        }
    }
}

