/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.request.QueryEngine;
import tech.ytsaurus.client.request.QueryState;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.rpcproxy.TQuery;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ytree.TAttribute;

public class Query {
    private final GUID id;
    @Nullable
    private final QueryEngine engine;
    @Nullable
    private final String query;
    @Nullable
    private final YTreeNode files;
    @Nullable
    private final Instant startTime;
    @Nullable
    private final Instant finishTime;
    private final YTreeNode settings;
    @Nullable
    private final String user;
    @Nullable
    private final YTreeNode accessControlObjects;
    @Nullable
    private final QueryState state;
    @Nullable
    private final Long resultCount;
    private final YTreeNode progress;
    @Nullable
    private final YTsaurusError error;
    private final YTreeNode annotations;
    private final Map<String, YTreeNode> otherAttributes;

    public Query(TQuery query) {
        this.id = RpcUtil.fromProto((TGuidOrBuilder)query.getId());
        this.engine = query.hasEngine() ? QueryEngine.fromProtoValue(query.getEngine()) : null;
        this.query = query.hasQuery() ? query.getQuery() : null;
        this.files = query.hasFiles() ? RpcUtil.parseByteString(query.getFiles()) : null;
        this.startTime = query.hasStartTime() ? RpcUtil.instantFromMicros(query.getStartTime()) : null;
        this.finishTime = query.hasFinishTime() ? RpcUtil.instantFromMicros(query.getFinishTime()) : null;
        this.settings = RpcUtil.parseByteString(query.getSettings());
        this.user = query.hasUser() ? query.getUser() : null;
        this.accessControlObjects = query.hasAccessControlObjects() ? RpcUtil.parseByteString(query.getAccessControlObjects()) : null;
        this.state = query.hasState() ? QueryState.fromProtoValue(query.getState()) : null;
        this.resultCount = query.hasResultCount() ? Long.valueOf(query.getResultCount()) : null;
        this.progress = RpcUtil.parseByteString(query.getProgress());
        this.error = query.hasError() ? new YTsaurusError(query.getError()) : null;
        this.annotations = RpcUtil.parseByteString(query.getAnnotations());
        this.otherAttributes = query.getOtherAttributes().getAttributesList().stream().collect(Collectors.toMap(TAttribute::getKey, attribute -> RpcUtil.parseByteString(attribute.getValue())));
    }

    public GUID getId() {
        return this.id;
    }

    public Optional<QueryEngine> getEngine() {
        return Optional.ofNullable(this.engine);
    }

    public Optional<String> getQuery() {
        return Optional.ofNullable(this.query);
    }

    public Optional<YTreeNode> getFiles() {
        return Optional.ofNullable(this.files);
    }

    public Optional<Instant> getStartTime() {
        return Optional.ofNullable(this.startTime);
    }

    public Optional<Instant> getFinishTime() {
        return Optional.ofNullable(this.finishTime);
    }

    public YTreeNode getSettings() {
        return this.settings;
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<YTreeNode> getAccessControlObjects() {
        return Optional.ofNullable(this.accessControlObjects);
    }

    public Optional<QueryState> getState() {
        return Optional.ofNullable(this.state);
    }

    public Optional<Long> getResultCount() {
        return Optional.ofNullable(this.resultCount);
    }

    public YTreeNode getProgress() {
        return this.progress;
    }

    public Optional<YTsaurusError> getError() {
        return Optional.ofNullable(this.error);
    }

    public YTreeNode getAnnotations() {
        return this.annotations;
    }

    public Map<String, YTreeNode> getOtherAttributes() {
        return this.otherAttributes;
    }
}

