/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.SuppressableAccessTrackingOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.rpcproxy.TReqReadFile;
import tech.ytsaurus.rpcproxy.TSuppressableAccessTrackingOptions;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class ReadFile
extends RequestBase<Builder, ReadFile> {
    private final String path;
    @Nullable
    private final Long offset;
    @Nullable
    private final Long length;
    @Nullable
    private final YTreeNode config;
    @Nullable
    private final TransactionalOptions transactionalOptions;
    @Nullable
    private final SuppressableAccessTrackingOptions suppressableAccessTrackingOptions;

    public ReadFile(BuilderBase<?> builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.offset = builder.offset;
        this.length = builder.length;
        this.config = builder.config != null ? YTree.deepCopy((YTreeNode)builder.config) : null;
        this.transactionalOptions = builder.transactionalOptions == null ? null : new TransactionalOptions(builder.transactionalOptions);
        this.suppressableAccessTrackingOptions = builder.suppressableAccessTrackingOptions == null ? null : new SuppressableAccessTrackingOptions(builder.suppressableAccessTrackingOptions);
    }

    public ReadFile(String path) {
        this((BuilderBase<?>)ReadFile.builder().setPath(path));
    }

    public static Builder builder() {
        return new Builder();
    }

    public TReqReadFile.Builder writeTo(TReqReadFile.Builder builder) {
        builder.setPath(ByteString.copyFromUtf8((String)this.path));
        if (this.offset != null) {
            builder.setOffset(this.offset.longValue());
        }
        if (this.length != null) {
            builder.setLength(this.length.longValue());
        }
        if (this.config != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)this.config, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            builder.setConfig(ByteString.copyFrom((byte[])data));
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.suppressableAccessTrackingOptions != null) {
            builder.setSuppressableAccessTrackingOptions(this.suppressableAccessTrackingOptions.writeTo(TSuppressableAccessTrackingOptions.newBuilder()));
        }
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
        return builder;
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ReadFile.builder().setPath(this.path)).setConfig(this.config)).setLength(this.length)).setOffset(this.offset)).setTransactionalOptions(this.transactionalOptions)).setSuppressableAccessTrackingOptions(this.suppressableAccessTrackingOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, ReadFile> {
        @Nullable
        private String path;
        @Nullable
        private Long offset = null;
        @Nullable
        private Long length = null;
        @Nullable
        private YTreeNode config = null;
        @Nullable
        private TransactionalOptions transactionalOptions = null;
        @Nullable
        private SuppressableAccessTrackingOptions suppressableAccessTrackingOptions = null;

        public TBuilder setPath(String path) {
            this.path = path;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOffset(@Nullable Long offset) {
            this.offset = offset;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setLength(@Nullable Long length) {
            this.length = length;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSuppressableAccessTrackingOptions(@Nullable SuppressableAccessTrackingOptions suppressableAccessTrackingOptions) {
            this.suppressableAccessTrackingOptions = suppressableAccessTrackingOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public ReadFile build() {
            return new ReadFile(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

