/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.SerializationContext;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.request.WriteSerializationContext;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.ERowsetFormat;
import tech.ytsaurus.rpcproxy.TReqReadTable;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class ReadTable<T>
extends RequestBase<Builder<T>, ReadTable<T>> {
    @Nullable
    private final YPath path;
    @Nullable
    private final String stringPath;
    private final SerializationContext<T> serializationContext;
    @Nullable
    private final TableSchema tableSchema;
    private final boolean unordered;
    private final boolean omitInaccessibleColumns;
    @Nullable
    private final YTreeNode config;
    @Nullable
    private final TransactionalOptions transactionalOptions;

    public ReadTable(BuilderBase<T, ?> builder) {
        super(builder);
        if (builder.path == null && builder.stringPath == null) {
            throw new IllegalArgumentException("Path wasn't set");
        }
        this.path = builder.path;
        this.stringPath = builder.stringPath;
        this.serializationContext = Objects.requireNonNull(builder.serializationContext);
        this.tableSchema = builder.tableSchema;
        this.unordered = builder.unordered;
        this.omitInaccessibleColumns = builder.omitInaccessibleColumns;
        this.config = builder.config;
        this.transactionalOptions = builder.transactionalOptions;
    }

    public ReadTable(YPath path, SerializationContext<T> serializationContext) {
        this((BuilderBase<T, ?>)((Builder)new Builder().setPath(path)).setSerializationContext(serializationContext));
    }

    public ReadTable(YPath path, Class<T> objectClass) {
        this((BuilderBase<T, ?>)((Builder)new Builder().setPath(path)).setSerializationContext(new SerializationContext<T>(objectClass)));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> rowClass) {
        return (Builder)new Builder<T>().setSerializationContext(new SerializationContext<T>(rowClass));
    }

    public SerializationContext<T> getSerializationContext() {
        return this.serializationContext;
    }

    public YPath getYPath() {
        return Objects.requireNonNull(this.path);
    }

    public Optional<TableSchema> getTableSchema() {
        return Optional.ofNullable(this.tableSchema);
    }

    public Optional<GUID> getTransactionId() {
        if (this.transactionalOptions == null) {
            return Optional.empty();
        }
        return this.transactionalOptions.getTransactionId();
    }

    private String getPath() {
        return this.path != null ? this.path.toString() : Objects.requireNonNull(this.stringPath);
    }

    public TReqReadTable.Builder writeTo(TReqReadTable.Builder builder) {
        byte[] data;
        ByteArrayOutputStream baos;
        builder.setUnordered(this.unordered);
        builder.setOmitInaccessibleColumns(this.omitInaccessibleColumns);
        builder.setPath(ByteString.copyFromUtf8((String)this.getPath()));
        if (this.config != null) {
            baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)this.config, (OutputStream)baos);
            data = baos.toByteArray();
            builder.setConfig(ByteString.copyFrom((byte[])data));
        }
        if (this.serializationContext.getFormat().isPresent()) {
            baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)this.serializationContext.getFormat().get().toTree(), (OutputStream)baos);
            data = baos.toByteArray();
            builder.setFormat(ByteString.copyFrom((byte[])data));
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
        builder.setDesiredRowsetFormat(this.serializationContext.getRowsetFormat());
        if (this.serializationContext.getRowsetFormat() == ERowsetFormat.RF_FORMAT && this.serializationContext.getFormat().isEmpty()) {
            throw new IllegalStateException("`format` is required for desiredRowsetFormat == RF_FORMAT");
        }
        return builder;
    }

    @Override
    public Builder<T> toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setPath(this.path)).setPath(this.stringPath)).setSerializationContext(this.serializationContext)).setTableSchema(this.tableSchema)).setUnordered(this.unordered)).setOmitInaccessibleColumns(this.omitInaccessibleColumns)).setConfig(this.config)).setTransactionalOptions(this.transactionalOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<T, TBuilder extends BuilderBase<T, TBuilder>>
    extends RequestBase.Builder<TBuilder, ReadTable<T>> {
        @Nullable
        private YPath path;
        @Nullable
        private String stringPath;
        @Nullable
        private SerializationContext<T> serializationContext;
        @Nullable
        private TableSchema tableSchema;
        private boolean unordered = false;
        private boolean omitInaccessibleColumns = false;
        @Nullable
        private YTreeNode config = null;
        @Nullable
        private TransactionalOptions transactionalOptions = null;

        public TBuilder setPath(@Nullable YPath path) {
            this.path = path;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Deprecated
        public TBuilder setPath(@Nullable String stringPath) {
            this.stringPath = stringPath;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSerializationContext(SerializationContext<T> serializationContext) {
            if (serializationContext instanceof WriteSerializationContext) {
                throw new IllegalArgumentException("WriteSerializationContext do not allowed here");
            }
            this.serializationContext = serializationContext;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTableSchema(@Nullable TableSchema tableSchema) {
            this.tableSchema = tableSchema;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setUnordered(boolean unordered) {
            this.unordered = unordered;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOmitInaccessibleColumns(boolean omitInaccessibleColumns) {
            this.omitInaccessibleColumns = omitInaccessibleColumns;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public ReadTable<T> build() {
            return new ReadTable(this);
        }
    }

    public static class Builder<T>
    extends BuilderBase<T, Builder<T>> {
        private Builder() {
        }

        @Override
        protected Builder<T> self() {
            return this;
        }
    }
}

