/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.Message;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.tracing.TTracingExt;

public abstract class RequestBase<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends RequestBase<TBuilder, TRequest>> {
    @Nullable
    protected Duration timeout;
    @Nullable
    protected GUID requestId;
    @Nullable
    protected GUID traceId;
    protected boolean traceSampled;
    protected String userAgent;
    @Nullable
    protected Message additionalData;

    protected RequestBase(Builder<?, ?> builder) {
        this.timeout = builder.timeout;
        this.requestId = builder.requestId;
        this.traceId = builder.traceId;
        this.traceSampled = builder.traceSampled;
        this.userAgent = builder.userAgent;
        this.additionalData = builder.additionalData;
    }

    protected RequestBase(RequestBase<?, ?> other) {
        this.timeout = other.timeout;
        this.requestId = other.requestId;
        this.traceId = other.traceId;
        this.traceSampled = other.traceSampled;
        this.userAgent = other.userAgent;
        this.additionalData = other.additionalData;
    }

    @Nullable
    Message getAdditionalData() {
        return this.additionalData;
    }

    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<GUID> getRequestId() {
        return Optional.ofNullable(this.requestId);
    }

    public Optional<GUID> getTraceId() {
        return Optional.ofNullable(this.traceId);
    }

    public boolean getTraceSampled() {
        return this.traceSampled;
    }

    public void writeHeaderTo(TRequestHeader.Builder header) {
        if (this.timeout != null) {
            header.setTimeout(RpcUtil.durationToMicros(this.timeout));
        }
        if (this.requestId != null) {
            header.setRequestId(RpcUtil.toProto(this.requestId));
        }
        if (this.traceId != null) {
            TTracingExt.Builder tracing = TTracingExt.newBuilder();
            tracing.setSampled(this.traceSampled);
            tracing.setTraceId(RpcUtil.toProto(this.traceId));
            header.setExtension(TRequestHeader.tracingExt, (Object)tracing.build());
        }
        header.setUserAgent(this.userAgent);
    }

    public final String getArgumentsLogString() {
        StringBuilder sb = new StringBuilder();
        this.writeArgumentsLogString(sb);
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected void writeArgumentsLogString(StringBuilder sb) {
    }

    public abstract TBuilder toBuilder();

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest> {
        @Nullable
        protected Duration timeout;
        @Nullable
        protected GUID requestId;
        @Nullable
        protected GUID traceId;
        protected boolean traceSampled = false;
        protected String userAgent = "yt/java/ytsaurus-client@";
        @Nullable
        protected Message additionalData;

        protected Builder() {
        }

        protected Builder(Builder<?, ?> other) {
            this.timeout = other.timeout;
            this.requestId = other.requestId;
            this.traceId = other.traceId;
            this.traceSampled = other.traceSampled;
            this.userAgent = other.userAgent;
            this.additionalData = other.additionalData;
        }

        public TBuilder setAdditionalData(@Nullable Message additionalData) {
            this.additionalData = additionalData;
            return this.self();
        }

        protected abstract TBuilder self();

        public abstract TRequest build();

        public TBuilder setTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this.self();
        }

        public TBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this.self();
        }

        public TBuilder setRequestId(@Nullable GUID requestId) {
            this.requestId = requestId;
            return this.self();
        }

        public TBuilder setTraceId(@Nullable GUID traceId) {
            this.traceId = traceId;
            return this.self();
        }

        public TBuilder setTraceId(@Nullable GUID traceId, boolean sampled) {
            if (sampled && traceId == null) {
                throw new IllegalArgumentException("traceId cannot be null if sampled == true");
            }
            this.traceId = traceId;
            this.traceSampled = sampled;
            return this.self();
        }

        @Nullable
        Message getAdditionalData() {
            return this.additionalData;
        }

        public Optional<Duration> getTimeout() {
            return Optional.ofNullable(this.timeout);
        }

        public Optional<GUID> getRequestId() {
            return Optional.ofNullable(this.requestId);
        }

        public Optional<GUID> getTraceId() {
            return Optional.ofNullable(this.traceId);
        }

        public boolean getTraceSampled() {
            return this.traceSampled;
        }

        public void writeHeaderTo(TRequestHeader.Builder header) {
            if (this.timeout != null) {
                header.setTimeout(RpcUtil.durationToMicros(this.timeout));
            }
            if (this.requestId != null) {
                header.setRequestId(RpcUtil.toProto(this.requestId));
            }
            if (this.traceId != null) {
                TTracingExt.Builder tracing = TTracingExt.newBuilder();
                tracing.setSampled(this.traceSampled);
                tracing.setTraceId(RpcUtil.toProto(this.traceId));
                header.setExtension(TRequestHeader.tracingExt, (Object)tracing.build());
            }
            header.setUserAgent(this.userAgent);
        }

        public final String getArgumentsLogString() {
            StringBuilder sb = new StringBuilder();
            this.writeArgumentsLogString(sb);
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }

        protected void writeArgumentsLogString(StringBuilder sb) {
        }
    }
}

