/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.TableReq;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.WireProtocolWriter;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TReqReshardTable;

public class ReshardTable
extends TableReq<Builder, ReshardTable>
implements HighLevelRequest<TReqReshardTable.Builder> {
    @Nullable
    private final Integer tabletCount;
    @Nullable
    private final TableSchema schema;
    private final List<UnversionedRow> pivotKeys;
    private final List<List<?>> unconvertedPivotKeys;

    public ReshardTable(BuilderBase<?> builder) {
        super((TableReq.Builder<?, ?>)builder);
        this.tabletCount = builder.tabletCount;
        this.schema = builder.schema;
        this.pivotKeys = new ArrayList<UnversionedRow>(builder.pivotKeys);
        this.unconvertedPivotKeys = new ArrayList(builder.unconvertedPivotKeys);
    }

    public ReshardTable(YPath path) {
        this((BuilderBase)ReshardTable.builder().setPath(path.justPath()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public void convertValues(SerializationResolver serializationResolver) {
        this.pivotKeys.addAll(this.unconvertedPivotKeys.stream().map(values -> this.convertValuesToRow((List<?>)values, serializationResolver)).collect(Collectors.toList()));
        this.unconvertedPivotKeys.clear();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqReshardTable.Builder, ?> requestBuilder) {
        TReqReshardTable.Builder builder = requestBuilder.body();
        super.writeTo(builder);
        if (this.schema != null) {
            builder.setRowsetDescriptor(ApiServiceUtil.makeRowsetDescriptor(this.schema));
        }
        if (this.tabletCount != null) {
            builder.setTabletCount(this.tabletCount.intValue());
        }
        if (!this.pivotKeys.isEmpty()) {
            this.serializeRowsetTo(requestBuilder.attachments());
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        if (this.schema != null) {
            sb.append("Schema: ").append(this.schema).append("; ");
        }
        if (this.tabletCount != null) {
            sb.append("TabletCount: ").append(this.tabletCount).append("; ");
        }
    }

    private void serializeRowsetTo(List<byte[]> attachments) {
        WireProtocolWriter writer = new WireProtocolWriter(attachments);
        writer.writeUnversionedRowset(this.pivotKeys, new UnversionedRowSerializer(this.schema));
        writer.finish();
    }

    private UnversionedRow convertValuesToRow(List<?> values, SerializationResolver serializationResolver) {
        if (this.schema == null) {
            throw new IllegalArgumentException("Schema for pivot keys must be set");
        }
        if (values.size() > this.schema.getKeyColumnsCount()) {
            throw new IllegalArgumentException("Pivot keys must contain only key columns");
        }
        ArrayList<UnversionedValue> row = new ArrayList<UnversionedValue>(values.size());
        ApiServiceUtil.convertKeyColumns(row, this.schema, values, true, serializationResolver);
        return new UnversionedRow(row);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ReshardTable.builder().setTabletCount(this.tabletCount)).setSchema(this.schema)).setPivotKeys(this.pivotKeys)).setUnconvertedPivotKeys(this.unconvertedPivotKeys)).setMutatingOptions(this.mutatingOptions)).setPath(this.path)).setTabletRangeOptions(this.tabletRangeOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends TableReq.Builder<TBuilder, ReshardTable> {
        @Nullable
        private Integer tabletCount;
        @Nullable
        private TableSchema schema;
        private final List<UnversionedRow> pivotKeys = new ArrayList<UnversionedRow>();
        private final List<List<?>> unconvertedPivotKeys = new ArrayList();

        protected BuilderBase() {
        }

        protected BuilderBase(BuilderBase<?> builder) {
            super((TableReq.Builder<?, ?>)builder);
            this.tabletCount = builder.tabletCount;
            this.schema = builder.schema;
            this.pivotKeys.clear();
            this.pivotKeys.addAll(builder.pivotKeys);
        }

        public TBuilder setTabletCount(@Nullable Integer tabletCount) {
            this.tabletCount = tabletCount;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSchema(@Nullable TableSchema schema) {
            this.schema = schema;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addPivotKey(List<?> values) {
            this.unconvertedPivotKeys.add(values);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setUnconvertedPivotKeys(List<List<?>> pivotKeys) {
            this.unconvertedPivotKeys.clear();
            this.unconvertedPivotKeys.addAll(pivotKeys);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPivotKeys(List<UnversionedRow> pivotKeys) {
            this.pivotKeys.clear();
            this.pivotKeys.addAll(pivotKeys);
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            if (this.schema != null) {
                sb.append("Schema: ").append(this.schema.toString()).append("; ");
            }
            if (this.tabletCount != null) {
                sb.append("TabletCount: ").append(this.tabletCount).append("; ");
            }
        }

        @Override
        public ReshardTable build() {
            return new ReshardTable(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

