/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MutatePath;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqSetNode;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

public class SetNode
extends MutatePath<Builder, SetNode>
implements HighLevelRequest<TReqSetNode.Builder> {
    private final byte[] value;
    private final boolean force;
    private final boolean recursive;

    public SetNode(BuilderBase<?> builder) {
        super((MutatePath.Builder<?, ?>)builder);
        this.value = (byte[])Objects.requireNonNull(builder.value).clone();
        this.force = builder.force;
        this.recursive = builder.recursive;
    }

    public SetNode(YPath path, YTreeNode value) {
        this((BuilderBase<?>)((Builder)SetNode.builder().setPath(path)).setValue(value));
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqSetNode.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.path.toString())).setForce(this.force).setValue(ByteString.copyFrom((byte[])this.value));
        if (this.transactionalOptions != null) {
            builder.body().setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.body().setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        builder.body().setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
        if (this.additionalData != null) {
            builder.body().mergeFrom(this.additionalData);
        }
        if (this.recursive) {
            builder.body().setRecursive(true);
        }
    }

    @Override
    public YTreeBuilder toTree(@Nonnull YTreeBuilder builder) {
        return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).when(this.force, b -> b.key("force").value(true)).when(this.recursive, b -> b.key("recursive").value(true));
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        if (this.force) {
            sb.append("Force: true; ");
        }
        if (this.recursive) {
            sb.append("Recursive: true; ");
        }
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)SetNode.builder().setPath(this.path)).setValue(this.value)).setForce(this.force)).setRecursive(this.recursive)).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData)).setMutatingOptions(new MutatingOptions(this.mutatingOptions));
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends MutatePath.Builder<TBuilder, SetNode> {
        @Nullable
        private byte[] value;
        private boolean force;
        private boolean recursive;

        protected BuilderBase() {
        }

        protected BuilderBase(BuilderBase<?> builder) {
            super((MutatePath.Builder<?, ?>)builder);
            if (builder.value != null) {
                this.value = Arrays.copyOf(builder.value, builder.value.length);
            }
            this.force = builder.force;
            this.recursive = builder.recursive;
        }

        public TBuilder setForce(boolean force) {
            this.force = force;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setRecursive(boolean recursive) {
            this.recursive = recursive;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setValue(byte[] value) {
            this.value = Arrays.copyOf(value, value.length);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setValue(YTreeNode value) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                YTreeBinarySerializer.serialize((YTreeNode)value, (OutputStream)baos);
                this.value = baos.toByteArray();
                baos.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public byte[] getValue() {
            return Objects.requireNonNull(this.value);
        }

        public boolean isForce() {
            return this.force;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        @Override
        public YTreeBuilder toTree(YTreeBuilder builder) {
            return builder.apply(x$0 -> super.toTree((YTreeBuilder)x$0)).when(this.force, b -> b.key("force").value(true)).when(this.recursive, b -> b.key("recursive").value(true));
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            if (this.force) {
                sb.append("Force: true; ");
            }
            if (this.recursive) {
                sb.append("Recursive: true; ");
            }
        }

        @Override
        public SetNode build() {
            return new SetNode(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

