/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpcproxy.EOperationType;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TReqStartOperation;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class StartOperation
extends RequestBase<Builder, StartOperation>
implements HighLevelRequest<TReqStartOperation.Builder> {
    private final EOperationType type;
    private final YTreeNode spec;
    @Nullable
    private final TransactionalOptions transactionalOptions;
    private final MutatingOptions mutatingOptions;

    public StartOperation(BuilderBase<?> builder) {
        super(builder);
        this.type = Objects.requireNonNull(builder.type);
        this.spec = Objects.requireNonNull(builder.spec);
        this.transactionalOptions = builder.transactionalOptions;
        this.mutatingOptions = builder.mutatingOptions;
    }

    public StartOperation(EOperationType type, YTreeNode spec) {
        this((BuilderBase<?>)((Builder)StartOperation.builder().setType(type)).setSpec(spec));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqStartOperation.Builder, ?> requestBuilder) {
        TReqStartOperation.Builder builder = requestBuilder.body();
        ByteString.Output output = ByteString.newOutput();
        YTreeBinarySerializer.serialize((YTreeNode)this.spec, (OutputStream)output);
        builder.setType(this.type).setSpec(output.toByteString());
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        builder.setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("OperationType: ").append(this.type).append("; ");
        if (this.transactionalOptions != null) {
            this.transactionalOptions.writeArgumentsLogString(sb);
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeHeaderTo(TRequestHeader.Builder header) {
        super.writeHeaderTo(header);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)StartOperation.builder().setType(this.type)).setSpec(this.spec)).setTransactionalOptions(this.transactionalOptions)).setMutatingOptions(this.mutatingOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, StartOperation> {
        @Nullable
        private EOperationType type;
        @Nullable
        private YTreeNode spec;
        @Nullable
        private TransactionalOptions transactionalOptions;
        private MutatingOptions mutatingOptions = new MutatingOptions().setMutationId(GUID.create());

        protected BuilderBase() {
        }

        BuilderBase(BuilderBase<?> builder) {
            super(builder);
            this.type = builder.type;
            this.spec = YTree.deepCopy((YTreeNode)this.spec);
            if (this.transactionalOptions != null) {
                this.transactionalOptions = new TransactionalOptions(this.transactionalOptions);
            }
            this.mutatingOptions = new MutatingOptions(this.mutatingOptions);
        }

        public TBuilder setType(EOperationType type) {
            this.type = type;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSpec(YTreeNode spec) {
            this.spec = spec;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setMutatingOptions(MutatingOptions mutatingOptions) {
            this.mutatingOptions = mutatingOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
            sb.append("OperationType: ").append(this.type).append("; ");
            super.writeArgumentsLogString(sb);
        }

        @Override
        public void writeHeaderTo(TRequestHeader.Builder header) {
            super.writeHeaderTo(header);
        }

        @Override
        public StartOperation build() {
            return new StartOperation(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

