/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.QueryEngine;
import tech.ytsaurus.client.request.QueryFile;
import tech.ytsaurus.client.request.QuerySecret;
import tech.ytsaurus.client.request.QueryTrackerReq;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.rpcproxy.TReqStartQuery;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

public class StartQuery
extends QueryTrackerReq<Builder, StartQuery>
implements HighLevelRequest<TReqStartQuery.Builder> {
    private final QueryEngine queryEngine;
    private final String query;
    @Nullable
    private final YTreeNode settings;
    private final boolean draft;
    @Nullable
    private final YTreeMapNode annotations;
    private final List<QueryFile> files;
    @Nullable
    private final List<String> accessControlObjects;
    private final List<QuerySecret> secrets;

    StartQuery(Builder builder) {
        super(builder);
        this.queryEngine = Objects.requireNonNull(builder.queryEngine);
        this.query = Objects.requireNonNull(builder.query);
        this.settings = builder.settings;
        this.draft = builder.draft;
        this.annotations = builder.annotations;
        this.files = Objects.requireNonNull(builder.files);
        this.accessControlObjects = builder.accessControlObjects;
        this.secrets = Objects.requireNonNull(builder.secrets);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)StartQuery.builder().setQueryEngine(this.queryEngine).setQuery(this.query).setSettings(this.settings).setDraft(this.draft).setAnnotations(this.annotations).setQueryFiles(this.files).setAccessControlObjects(this.accessControlObjects).setQueryTrackerStage(this.queryTrackerStage)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData)).setQuerySecrets(this.secrets);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqStartQuery.Builder, ?> requestBuilder) {
        TReqStartQuery.Builder builder = requestBuilder.body();
        this.writeQueryTrackerDescriptionToProto(arg_0 -> ((TReqStartQuery.Builder)builder).setQueryTrackerStage(arg_0));
        builder.setEngine(this.queryEngine.getProtoValue());
        builder.setQuery(this.query);
        builder.setDraft(this.draft);
        if (this.settings != null) {
            builder.setSettings(ByteString.copyFrom((byte[])this.settings.toBinary()));
        }
        if (this.annotations != null) {
            builder.setAnnotations(ByteString.copyFrom((byte[])this.annotations.toBinary()));
        }
        if (this.accessControlObjects != null) {
            builder.setAccessControlObjects(TReqStartQuery.TAccessControlObjects.newBuilder().addAllItems(this.accessControlObjects).build());
        }
        builder.addAllFiles((Iterable)this.files.stream().map(QueryFile::toProto).collect(Collectors.toList()));
        builder.addAllSecrets((Iterable)this.secrets.stream().map(QuerySecret::toProto).collect(Collectors.toList()));
    }

    public static class Builder
    extends QueryTrackerReq.Builder<Builder, StartQuery> {
        @Nullable
        private QueryEngine queryEngine;
        @Nullable
        private String query;
        @Nullable
        private YTreeNode settings;
        private boolean draft;
        @Nullable
        private YTreeMapNode annotations;
        @Nullable
        private List<QueryFile> files;
        @Nullable
        private List<String> accessControlObjects;
        @Nullable
        private List<QuerySecret> secrets;

        private Builder() {
        }

        public Builder setQueryEngine(QueryEngine queryEngine) {
            this.queryEngine = queryEngine;
            return this.self();
        }

        public Builder setQuery(String query) {
            this.query = query;
            return this.self();
        }

        public Builder setSettings(@Nullable YTreeNode settings) {
            this.settings = settings;
            return this.self();
        }

        public Builder setDraft(boolean draft) {
            this.draft = draft;
            return this.self();
        }

        public Builder setAnnotations(@Nullable YTreeMapNode annotations) {
            this.annotations = annotations;
            return this.self();
        }

        public Builder setQueryFiles(List<QueryFile> files) {
            this.files = files;
            return this.self();
        }

        public Builder setAccessControlObjects(@Nullable List<String> accessControlObjects) {
            this.accessControlObjects = accessControlObjects;
            return this.self();
        }

        public Builder setQuerySecrets(List<QuerySecret> secrets) {
            this.secrets = secrets;
            return this.self();
        }

        @Override
        public StartQuery build() {
            return new StartQuery(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

