/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.request.Atomicity;
import tech.ytsaurus.client.request.Durability;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TransactionType;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqStartTransaction;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ytree.TAttributeDictionary;

public class StartTransaction
extends RequestBase<Builder, StartTransaction>
implements HighLevelRequest<TReqStartTransaction.Builder> {
    private final TransactionType type;
    private final boolean sticky;
    private final Duration transactionTimeout;
    @Nullable
    private final Instant deadline;
    @Nullable
    private final GUID id;
    @Nullable
    private final GUID parentId;
    private final boolean ping;
    private final boolean pingAncestors;
    @Nullable
    private final Atomicity atomicity;
    @Nullable
    private final Durability durability;
    @Nullable
    private final Duration pingPeriod;
    @Nullable
    private final Duration failedPingRetryPeriod;
    private final Map<String, YTreeNode> attributes;
    @Nullable
    private final Consumer<Exception> onPingFailed;

    public StartTransaction(BuilderBase<?> builder) {
        super(builder);
        this.type = Objects.requireNonNull(builder.type);
        this.sticky = Objects.requireNonNull(builder.sticky);
        this.transactionTimeout = builder.transactionTimeout;
        this.deadline = builder.deadline;
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.ping = builder.ping;
        this.pingAncestors = builder.pingAncestors;
        this.atomicity = builder.atomicity;
        this.durability = builder.durability;
        this.pingPeriod = builder.pingPeriod;
        this.failedPingRetryPeriod = builder.failedPingRetryPeriod;
        this.attributes = new HashMap<String, YTreeNode>(builder.attributes);
        this.onPingFailed = builder.onPingFailed;
    }

    public StartTransaction(TransactionType type) {
        this(type, type == TransactionType.Tablet);
    }

    private StartTransaction(TransactionType type, boolean sticky) {
        this((BuilderBase<?>)((Builder)StartTransaction.builder().setType(type)).setSticky(sticky));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StartTransaction master() {
        return new StartTransaction(TransactionType.Master);
    }

    public static StartTransaction tablet() {
        return new StartTransaction(TransactionType.Tablet);
    }

    public static StartTransaction stickyMaster() {
        return new StartTransaction(TransactionType.Master, true);
    }

    public TransactionType getType() {
        return Objects.requireNonNull(this.type);
    }

    public Duration getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public Optional<Duration> getPingPeriod() {
        return Optional.ofNullable(this.pingPeriod);
    }

    public Optional<Duration> getFailedPingRetryPeriod() {
        return Optional.ofNullable(this.failedPingRetryPeriod);
    }

    public Optional<Consumer<Exception>> getOnPingFailed() {
        return Optional.ofNullable(this.onPingFailed);
    }

    public Optional<Instant> getDeadline() {
        return Optional.ofNullable(this.deadline);
    }

    public Optional<GUID> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<GUID> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public Optional<Atomicity> getAtomicity() {
        return Optional.ofNullable(this.atomicity);
    }

    public Optional<Durability> getDurability() {
        return Optional.ofNullable(this.durability);
    }

    public boolean getPing() {
        return this.ping;
    }

    public boolean getPingAncestors() {
        return this.pingAncestors;
    }

    public boolean getSticky() {
        return Objects.requireNonNull(this.sticky);
    }

    public Map<String, YTreeNode> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqStartTransaction.Builder, ?> builder) {
        builder.body().setType(this.type.getProtoValue());
        builder.body().setTimeout(ApiServiceUtil.durationToYtMicros(this.transactionTimeout));
        if (this.deadline != null) {
            builder.body().setDeadline(ApiServiceUtil.instantToYtMicros(this.deadline));
        }
        if (this.id != null) {
            builder.body().setId(RpcUtil.toProto(this.id));
        }
        if (this.parentId != null) {
            builder.body().setParentId(RpcUtil.toProto(this.parentId));
        }
        if (this.ping != TReqStartTransaction.getDefaultInstance().getPing()) {
            builder.body().setPing(this.ping);
        }
        if (this.pingAncestors != TReqStartTransaction.getDefaultInstance().getPingAncestors()) {
            builder.body().setPingAncestors(this.pingAncestors);
        }
        if (this.sticky != TReqStartTransaction.getDefaultInstance().getSticky()) {
            builder.body().setSticky(this.sticky);
        }
        if (this.atomicity != null) {
            builder.body().setAtomicity(this.atomicity.getProtoValue());
        }
        if (this.durability != null) {
            builder.body().setDurability(this.durability.getProtoValue());
        }
        if (!this.attributes.isEmpty()) {
            TAttributeDictionary.Builder attributesBuilder = builder.body().getAttributesBuilder();
            for (Map.Entry<String, YTreeNode> entry : this.attributes.entrySet()) {
                attributesBuilder.addAttributesBuilder().setKey(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue().toBinary()));
            }
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("Type: ").append((Object)this.type);
        sb.append("; TransactionTimeout: ").append(this.transactionTimeout);
        if (this.parentId != null) {
            sb.append("; ParentId: ").append(this.parentId);
        }
        if (this.atomicity != null) {
            sb.append("; Atomicity: ").append((Object)this.atomicity);
        }
        if (this.durability != null) {
            sb.append("; Durability: ").append((Object)this.durability);
        }
        sb.append(";");
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)StartTransaction.builder().setType(this.type)).setSticky(this.sticky)).setTransactionTimeout(this.transactionTimeout)).setDeadline(this.deadline)).setId(this.id)).setParentId(this.parentId)).setPing(this.ping)).setPingAncestors(this.pingAncestors)).setAtomicity(this.atomicity)).setDurability(this.durability)).setPingPeriod(this.pingPeriod)).setFailedPingRetryPeriod(this.failedPingRetryPeriod)).setAttributes(this.attributes)).setOnPingFailed(this.onPingFailed)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, StartTransaction> {
        @Nullable
        private TransactionType type;
        @Nullable
        private Boolean sticky;
        private Duration transactionTimeout = Duration.ofSeconds(15L);
        @Nullable
        private Instant deadline = null;
        @Nullable
        private GUID id = null;
        @Nullable
        private GUID parentId = null;
        private boolean ping = TReqStartTransaction.getDefaultInstance().getPing();
        private boolean pingAncestors = TReqStartTransaction.getDefaultInstance().getPingAncestors();
        @Nullable
        private Atomicity atomicity;
        @Nullable
        private Durability durability;
        @Nullable
        private Duration pingPeriod = Duration.ofSeconds(5L);
        @Nullable
        private Duration failedPingRetryPeriod;
        private final Map<String, YTreeNode> attributes = new HashMap<String, YTreeNode>();
        @Nullable
        private Consumer<Exception> onPingFailed;

        public TBuilder setType(TransactionType type) {
            this.type = type;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSticky(boolean sticky) {
            this.sticky = sticky;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionTimeout(Duration timeout) {
            this.transactionTimeout = timeout;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPingPeriod(@Nullable Duration pingPeriod) {
            this.pingPeriod = pingPeriod;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setFailedPingRetryPeriod(@Nullable Duration failedPingRetryPeriod) {
            this.failedPingRetryPeriod = failedPingRetryPeriod;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOnPingFailed(@Nullable Consumer<Exception> onPingFailed) {
            this.onPingFailed = onPingFailed;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setDeadline(@Nullable Instant deadline) {
            this.deadline = deadline;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setId(@Nullable GUID id) {
            this.id = GUID.isEmpty((GUID)id) ? null : id;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setParentId(@Nullable GUID parentId) {
            this.parentId = GUID.isEmpty((GUID)parentId) ? null : parentId;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAtomicity(@Nullable Atomicity atomicity) {
            this.atomicity = atomicity;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setDurability(@Nullable Durability durability) {
            this.durability = durability;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPing(boolean ping) {
            this.ping = ping;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPingAncestors(boolean pingAncestors) {
            this.pingAncestors = pingAncestors;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAttributes(@Nonnull Map<String, YTreeNode> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public StartTransaction build() {
            return new StartTransaction(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

