/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TabletRangeOptions;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.YPath;

public abstract class TableReq<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends RequestBase<TBuilder, TRequest>>
extends RequestBase<TBuilder, TRequest> {
    protected final String path;
    protected final MutatingOptions mutatingOptions;
    @Nullable
    protected final TabletRangeOptions tabletRangeOptions;

    TableReq(Builder<?, ?> builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.mutatingOptions = new MutatingOptions(builder.mutatingOptions);
        this.tabletRangeOptions = builder.tabletRangeOptions;
    }

    public String getPath() {
        return this.path;
    }

    public <R extends AbstractMessage.Builder<R>> R writeTo(R builder) {
        if (this.tabletRangeOptions != null) {
            builder.setField(builder.getDescriptorForType().findFieldByName("tablet_range_options"), (Object)this.tabletRangeOptions.toProto());
        }
        builder.setField(builder.getDescriptorForType().findFieldByName("mutating_options"), (Object)this.mutatingOptions.toProto());
        builder.setField(builder.getDescriptorForType().findFieldByName("path"), (Object)ByteString.copyFromUtf8((String)this.getPath()));
        return builder;
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("Path: ").append(this.getPath()).append("; ");
        super.writeArgumentsLogString(sb);
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends RequestBase<?, TRequest>>
    extends RequestBase.Builder<TBuilder, TRequest> {
        @Nullable
        protected String path;
        protected MutatingOptions mutatingOptions = new MutatingOptions().setMutationId(GUID.create());
        @Nullable
        protected TabletRangeOptions tabletRangeOptions;

        Builder() {
        }

        Builder(Builder<?, ?> builder) {
            super(builder);
            this.path = builder.path;
            this.mutatingOptions = new MutatingOptions(builder.mutatingOptions);
            this.tabletRangeOptions = builder.tabletRangeOptions;
        }

        public TBuilder setPath(YPath path) {
            this.path = path.justPath().toString();
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setPath(String path) {
            this.path = path;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setMutatingOptions(MutatingOptions mutatingOptions) {
            this.mutatingOptions = mutatingOptions;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setTabletRangeOptions(@Nullable TabletRangeOptions tabletRangeOptions) {
            this.tabletRangeOptions = tabletRangeOptions;
            return (TBuilder)((Builder)this.self());
        }

        public String getPath() {
            return Objects.requireNonNull(this.path);
        }

        public <R extends AbstractMessage.Builder<R>> R writeTo(R builder) {
            if (this.tabletRangeOptions != null) {
                builder.setField(builder.getDescriptorForType().findFieldByName("tablet_range_options"), (Object)this.tabletRangeOptions.toProto());
            }
            builder.setField(builder.getDescriptorForType().findFieldByName("mutating_options"), (Object)this.mutatingOptions.toProto());
            builder.setField(builder.getDescriptorForType().findFieldByName("path"), (Object)this.getPath());
            return builder;
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            sb.append("Path: ").append(this.getPath()).append("; ");
            super.writeArgumentsLogString(sb);
        }
    }
}

