/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqWriteFile;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class WriteFile
extends RequestBase<Builder, WriteFile> {
    private final String path;
    @Nullable
    private final YTreeNode config;
    @Nullable
    private final Boolean computeMd5;
    @Nullable
    private final TransactionalOptions transactionalOptions;
    @Nullable
    private final PrerequisiteOptions prerequisiteOptions;
    private final long windowSize;
    private final long packetSize;

    public WriteFile(BuilderBase<?> builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.config = builder.config;
        this.computeMd5 = builder.computeMd5;
        this.transactionalOptions = builder.transactionalOptions != null ? new TransactionalOptions(builder.transactionalOptions) : null;
        this.prerequisiteOptions = builder.prerequisiteOptions != null ? new PrerequisiteOptions(builder.prerequisiteOptions) : null;
        this.windowSize = builder.windowSize;
        this.packetSize = builder.packetSize;
    }

    public WriteFile(String path) {
        this((BuilderBase<?>)WriteFile.builder().setPath(path));
    }

    public static Builder builder() {
        return new Builder();
    }

    public YPath getPath() {
        return YPath.simple((String)this.path);
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public TReqWriteFile.Builder writeTo(TReqWriteFile.Builder builder) {
        builder.setPath(ByteString.copyFromUtf8((String)this.path));
        if (this.computeMd5 != null) {
            builder.setComputeMd5(this.computeMd5.booleanValue());
        }
        if (this.config != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)this.config, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            builder.setConfig(ByteString.copyFrom((byte[])data));
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
        return builder;
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)WriteFile.builder().setPath(this.path)).setConfig(this.config)).setComputeMd5(this.computeMd5)).setTransactionalOptions(this.transactionalOptions)).setPrerequisiteOptions(this.prerequisiteOptions)).setWindowSize(this.windowSize)).setPacketSize(this.packetSize);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, WriteFile> {
        @Nullable
        private String path;
        @Nullable
        private YTreeNode config = null;
        @Nullable
        private Boolean computeMd5 = null;
        @Nullable
        private TransactionalOptions transactionalOptions = null;
        @Nullable
        private PrerequisiteOptions prerequisiteOptions = null;
        private long windowSize = 16000000L;
        private long packetSize = this.windowSize / 2L;

        public TBuilder setPath(String path) {
            this.path = path;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWindowSize(long windowSize) {
            this.windowSize = windowSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPacketSize(long packetSize) {
            this.packetSize = packetSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions to) {
            this.transactionalOptions = to;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPrerequisiteOptions(@Nullable PrerequisiteOptions prerequisiteOptions) {
            this.prerequisiteOptions = prerequisiteOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setComputeMd5(@Nullable Boolean flag) {
            this.computeMd5 = flag;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public WriteFile build() {
            return new WriteFile(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

