/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.Format;
import tech.ytsaurus.client.request.ReadSerializationContext;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.SerializationContext;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TReqWriteTable;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class WriteTable<T>
extends RequestBase<Builder<T>, WriteTable<T>> {
    @Nullable
    private final YPath path;
    @Nullable
    private final String stringPath;
    private final SerializationContext<T> serializationContext;
    @Nullable
    private final TableSchema tableSchema;
    @Nullable
    private final YTreeNode config;
    @Nullable
    private final TransactionalOptions transactionalOptions;
    private final long windowSize;
    private final long packetSize;
    private final boolean needRetries;
    private final int maxWritesInFlight;
    private final int chunkSize;

    public WriteTable(YPath path, SerializationContext<T> serializationContext) {
        this((BuilderBase<T, ?>)((Builder)new Builder().setPath(path)).setSerializationContext(serializationContext));
    }

    public WriteTable(YPath path, Class<T> objectClass) {
        this((BuilderBase<T, ?>)((Builder)new Builder().setPath(path)).setSerializationContext(new SerializationContext<T>(objectClass)));
    }

    public WriteTable(YPath path, SerializationContext<T> serializationContext, TableSchema tableSchema) {
        this((BuilderBase<T, ?>)((Builder)((Builder)new Builder().setPath(path)).setSerializationContext(serializationContext)).setTableSchema(tableSchema));
    }

    public WriteTable(BuilderBase<T, ?> builder) {
        super(builder);
        this.serializationContext = Objects.requireNonNull(builder.serializationContext);
        this.tableSchema = builder.tableSchema;
        this.path = builder.path;
        this.stringPath = builder.stringPath;
        this.config = builder.config;
        this.transactionalOptions = builder.transactionalOptions;
        this.windowSize = builder.windowSize;
        this.packetSize = builder.packetSize;
        this.needRetries = builder.needRetries;
        this.maxWritesInFlight = builder.maxWritesInFlight;
        this.chunkSize = builder.chunkSize;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> rowClass) {
        return (Builder)new Builder<T>().setSerializationContext(new SerializationContext<T>(rowClass));
    }

    public SerializationContext<T> getSerializationContext() {
        return this.serializationContext;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public boolean getNeedRetries() {
        return this.needRetries;
    }

    public int getMaxWritesInFlight() {
        return this.maxWritesInFlight;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Optional<TableSchema> getTableSchema() {
        return Optional.ofNullable(this.tableSchema);
    }

    public Optional<GUID> getTransactionId() {
        if (this.transactionalOptions == null) {
            return Optional.empty();
        }
        return this.transactionalOptions.getTransactionId();
    }

    public String getPath() {
        return this.path != null ? this.path.toString() : Objects.requireNonNull(this.stringPath);
    }

    public YPath getYPath() {
        return Objects.requireNonNull(this.path);
    }

    public TReqWriteTable.Builder writeTo(TReqWriteTable.Builder builder) {
        Optional<Format> format;
        builder.setPath(ByteString.copyFromUtf8((String)this.getPath()));
        if (this.config != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)this.config, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            builder.setConfig(ByteString.copyFrom((byte[])data));
        } else {
            builder.setConfig(ByteString.copyFrom((String)"{}", (Charset)StandardCharsets.UTF_8));
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.additionalData != null) {
            builder.mergeFrom(this.additionalData);
        }
        if ((format = this.serializationContext.getFormat()).isPresent()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            YTreeBinarySerializer.serialize((YTreeNode)format.get().toTree(), (OutputStream)baos);
            byte[] data = baos.toByteArray();
            builder.setFormat(ByteString.copyFrom((byte[])data));
        }
        return builder;
    }

    @Override
    public Builder<T> toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().setPath(this.path)).setPath(this.stringPath)).setSerializationContext(this.serializationContext)).setTableSchema(this.tableSchema)).setNeedRetries(this.needRetries)).setMaxWritesInFlight(this.maxWritesInFlight)).setChunkSize(this.chunkSize)).setWindowSize(this.windowSize)).setPacketSize(this.packetSize)).setConfig(this.config)).setTransactionalOptions(this.transactionalOptions)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<T, TBuilder extends BuilderBase<T, TBuilder>>
    extends RequestBase.Builder<TBuilder, WriteTable<T>> {
        @Nullable
        private YPath path;
        @Nullable
        private String stringPath;
        @Nullable
        private SerializationContext<T> serializationContext;
        @Nullable
        private TableSchema tableSchema;
        @Nullable
        private YTreeNode config = null;
        @Nullable
        private TransactionalOptions transactionalOptions = null;
        private long windowSize = 16000000L;
        private long packetSize = this.windowSize / 2L;
        private boolean needRetries = true;
        private int maxWritesInFlight = 1;
        private int chunkSize = 524288000;

        public TBuilder setPath(@Nullable YPath path) {
            this.path = path;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Deprecated
        public TBuilder setPath(@Nullable String path) {
            this.stringPath = path;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSerializationContext(SerializationContext<T> serializationContext) {
            if (serializationContext instanceof ReadSerializationContext) {
                throw new IllegalArgumentException("ReadSerializationContext do not allowed here");
            }
            this.serializationContext = serializationContext;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTableSchema(@Nullable TableSchema tableSchema) {
            this.tableSchema = tableSchema;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setNeedRetries(boolean needRetries) {
            this.needRetries = needRetries;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setMaxWritesInFlight(int maxWritesInFlight) {
            this.maxWritesInFlight = maxWritesInFlight;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setChunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWindowSize(long windowSize) {
            this.windowSize = windowSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPacketSize(long packetSize) {
            this.packetSize = packetSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return (TBuilder)((BuilderBase)this.self());
        }

        public String getPath() {
            return this.path != null ? this.path.toString() : Objects.requireNonNull(this.stringPath);
        }

        public TReqWriteTable.Builder writeTo(TReqWriteTable.Builder builder) {
            Optional<Format> format;
            builder.setPath(ByteString.copyFromUtf8((String)this.getPath()));
            if (this.config != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                YTreeBinarySerializer.serialize((YTreeNode)this.config, (OutputStream)baos);
                byte[] data = baos.toByteArray();
                builder.setConfig(ByteString.copyFrom((byte[])data));
            } else {
                builder.setConfig(ByteString.copyFrom((String)"{}", (Charset)StandardCharsets.UTF_8));
            }
            if (this.transactionalOptions != null) {
                builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
            }
            if (this.additionalData != null) {
                builder.mergeFrom(this.additionalData);
            }
            if ((format = Objects.requireNonNull(this.serializationContext).getFormat()).isPresent()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                YTreeBinarySerializer.serialize((YTreeNode)format.get().toTree(), (OutputStream)baos);
                byte[] data = baos.toByteArray();
                builder.setFormat(ByteString.copyFrom((byte[])data));
            }
            return builder;
        }

        @Override
        public WriteTable<T> build() {
            return new WriteTable(this);
        }
    }

    public static class Builder<T>
    extends BuilderBase<T, Builder<T>> {
        private Builder() {
        }

        @Override
        protected Builder<T> self() {
            return this;
        }
    }
}

