/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ChunkedWriterMarker {
    private byte[] mark;
    private int markPos;

    void onArray(byte[] currentArray, byte[] newArray) {
        if (this.mark != currentArray) {
            return;
        }
        this.mark = newArray;
        if (this.markPos >= this.mark.length) {
            throw new IllegalArgumentException("Incorrect position at flush: " + this.markPos + ", length is limited to " + this.mark.length);
        }
    }

    void mark(byte[] currentArray, int position) {
        this.mark = currentArray;
        this.markPos = position;
        if (this.markPos >= this.mark.length) {
            throw new IllegalArgumentException("Incorrect position: " + this.markPos + ", length is limited to " + this.mark.length);
        }
    }

    public void writeToMark(ByteBuffer wrappedBuffer, ByteOrder order, long value) {
        if (this.mark == null) {
            throw new IllegalStateException("Buffer never marked");
        }
        if (wrappedBuffer != null && wrappedBuffer.hasArray() && wrappedBuffer.array() == this.mark) {
            wrappedBuffer.putLong(this.markPos, value);
        } else {
            ByteBuffer.wrap(this.mark, this.markPos, this.mark.length - this.markPos).order(order).putLong(value);
        }
    }
}

