/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.core.utils.ClassUtils;

class JavaPersistenceApi {
    private static final List<String> PACKAGES = List.of("javax.persistence", "jakarta.persistence");
    private static final String ENTITY = "Entity";
    private static final String ENTITY_NAME = "name";
    private static final String TRANSIENT = "Transient";
    private static final String COLUMN = "Column";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_NULLABLE = "nullable";
    private static final String COLUMN_PRECISION = "precision";
    private static final String COLUMN_SCALE = "scale";
    private static final String COLUMN_DEFINITION = "columnDefinition";
    private static final String EMBEDDABLE = "Embeddable";
    private static final String EMBEDDED = "Embedded";
    private static final Set<String> ENTITY_ANNOTATIONS = JavaPersistenceApi.getAnnotationsFor("Entity");
    private static final Set<String> TRANSIENT_ANNOTATIONS = JavaPersistenceApi.getAnnotationsFor("Transient");
    private static final Set<String> COLUMN_ANNOTATIONS = JavaPersistenceApi.getAnnotationsFor("Column");
    private static final Set<String> EMBEDDABLE_ANNOTATIONS = JavaPersistenceApi.getAnnotationsFor("Embeddable");
    private static final Set<String> EMBEDDED_ANNOTATIONS = JavaPersistenceApi.getAnnotationsFor("Embedded");

    private JavaPersistenceApi() {
    }

    static Set<String> transientAnnotations() {
        return TRANSIENT_ANNOTATIONS;
    }

    static Set<String> entityAnnotations() {
        return ENTITY_ANNOTATIONS;
    }

    static Set<String> columnAnnotations() {
        return COLUMN_ANNOTATIONS;
    }

    static Set<String> embeddableAnnotations() {
        return EMBEDDABLE_ANNOTATIONS;
    }

    static Set<String> embeddedAnnotations() {
        return EMBEDDED_ANNOTATIONS;
    }

    static boolean isColumnAnnotationPresent(@Nullable Annotation annotation) {
        return annotation != null && ClassUtils.anyMatchWithAnnotation((Annotation)annotation, JavaPersistenceApi.columnAnnotations());
    }

    static String getEntityName(Annotation entityAnnotation) {
        return (String)ClassUtils.getValueOfAnnotationProperty((Annotation)entityAnnotation, (String)"name");
    }

    static String getColumnName(Annotation columnAnnotation) {
        return (String)ClassUtils.getValueOfAnnotationProperty((Annotation)columnAnnotation, (String)"name");
    }

    static boolean isColumnNullable(Annotation columnAnnotation) {
        return (Boolean)ClassUtils.getValueOfAnnotationProperty((Annotation)columnAnnotation, (String)COLUMN_NULLABLE);
    }

    static int getColumnPrecision(Annotation columnAnnotation) {
        return (Integer)ClassUtils.getValueOfAnnotationProperty((Annotation)columnAnnotation, (String)COLUMN_PRECISION);
    }

    static int getColumnScale(Annotation columnAnnotation) {
        return (Integer)ClassUtils.getValueOfAnnotationProperty((Annotation)columnAnnotation, (String)COLUMN_SCALE);
    }

    static String getColumnDefinition(Annotation columnAnnotation) {
        return (String)ClassUtils.getValueOfAnnotationProperty((Annotation)columnAnnotation, (String)COLUMN_DEFINITION);
    }

    private static Set<String> getAnnotationsFor(String annotationName) {
        return PACKAGES.stream().map(pack -> pack + "." + annotationName).collect(Collectors.toUnmodifiableSet());
    }
}

